jQuery(function($) {

/* -----------------------------------------
    Counter
    ----------------------------------------- */
    if ($('#expert_coaching_counter_section').length) {
        var counted = 0;
        $(window).on('load scroll', function() {
            var oTop = $('#expert_coaching_counter_section').offset().top - window.innerHeight;
            if (counted == 0 && $(window).scrollTop() > oTop) {
                $('.count').each(function() {
                    var $this = $(this),
                    countTo = $this.attr('data-count');
                    $({
                        countNum: $this.text()
                    }).animate({
                        countNum: countTo
                    }, {
                        duration: 2000,
                        easing: 'swing',
                        step: function() {
                            $this.text(Math.floor(this.countNum));
                        },
                        complete: function() {
                            $this.text(this.countNum);
                        }
                    });
                });
                counted = 1;
            }
        });
    }

    /* -----------------------------------------
    Featured Video
    ----------------------------------------- */
    $('.expert-coaching-video-popup').magnificPopup({
        type: 'iframe',
        mainClass: 'mfp-fade',
        preloader: true,
    });

    $('.image-popup').magnificPopup({
        type: 'image',
    });

});