<?php
/*This file is part of EleNews child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

function elenews_enqueue_child_styles()
{
    $min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

    $parent_style = 'covernews-style';
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap' . $min . '.css');
    wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
    wp_enqueue_style(
        'elenews',
        get_stylesheet_directory_uri() . '/style.css',
        array('bootstrap', $parent_style),
        wp_get_theme()->get('Version')
    );
}
add_action('wp_enqueue_scripts', 'elenews_enqueue_child_styles');

/**
 * slider additions.
 */
require get_stylesheet_directory() . '/inc/hooks/hook-front-page-main-banner-section-9.php';



/**
 * Front-page main banner section layout
 */
if (!function_exists('elenews_front_page_main_section_selection')) {

    function elenews_front_page_main_section_selection()
    {

        $hide_on_blog = covernews_get_option('disable_main_banner_on_blog_archive');
        $main_banner_mode = covernews_get_option('select_main_banner_section_mode');
        

        if ($hide_on_blog) {
            if (is_front_page() && !is_home()) {
                if($main_banner_mode == 'slider-grid-2'){
                    do_action('elenews_action_front_page_main_section_9');
                }else{
                    do_action('covernews_action_front_page_main_section_1');
                }
                
            }
        } else {
            if (is_front_page() || is_home()) {
                if($main_banner_mode == 'slider-grid-2'){
                    do_action('elenews_action_front_page_main_section_9');
                }else{
                    do_action('covernews_action_front_page_main_section_1');
                }
            }
        }
    }
}
add_action('elenews_action_front_page_main_section', 'elenews_front_page_main_section_selection');


function elenews_filter_default_theme_options($defaults)
{

    $defaults['select_main_banner_section_mode'] = 'slider-editors-picks-trending';
    $defaults['select_main_banner_section_order_1'] = 'order-2';
    $defaults['select_main_banner_section_order_2'] = 'order-1';

    return $defaults;
}
add_filter('covernews_filter_default_theme_options', 'elenews_filter_default_theme_options', 1);
function elenews_customize_register($wp_customize)
{
    $default = covernews_get_default_theme_options();
    // Setting - select_main_banner_section_mode.
    $wp_customize->add_setting(
        'select_main_banner_section_mode',
        array(
            'default'           => $default['select_main_banner_section_mode'],
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'covernews_sanitize_select',
        )
    );

    $wp_customize->add_control(
        'select_main_banner_section_mode',
        array(
            'label'       => esc_html__('Select Banner Section Mode', 'elenews'),
            'description' => esc_html__('Select Banner Section Mode', 'elenews'),
            'section'     => 'frontpage_main_banner_section_settings',
            'type'        => 'select',
            'choices'               => array(
                'slider-editors-picks-trending' => esc_html__("Default", 'elenews'),
                'slider-grid-2' => esc_html__("Slider and a Grid", 'elenews'),

            ),
            'priority'    => 23,
            'active_callback' => 'covernews_main_banner_section_status'
        )
    );
}

add_action('customize_register', 'elenews_customize_register');
