<?php
/**
 * Eco Travel Functions
*/
 // For Getting Started
 define( 'TRAVEL_AGENCY_THEME_TEXTDOMAIN', 'eco-travel' );
/**
 * After setup theme hook
 */
function eco_travel_theme_setup(){
    /*
     * Make chile theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'eco-travel', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'eco_travel_theme_setup' );

/**
 * Load assets.
 */
function eco_travel_enqueue_styles() {
    $my_theme = wp_get_theme();
    $version = $my_theme['Version'];
    
    wp_enqueue_style( 'travel-agency-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'eco-travel-style', get_stylesheet_directory_uri() . '/style.css', array( 'travel-agency-style' ), $version );
}
add_action( 'wp_enqueue_scripts', 'eco_travel_enqueue_styles' );

/**
 * Remove action from parent
*/
function eco_travel_remove_action(){
    remove_action( 'customize_register', 'travel_agency_customizer_theme_info' );
    remove_action( 'customize_register', 'travel_agency_customizer_demo_content' );    
}
add_action( 'init', 'eco_travel_remove_action' );


function eco_travel_customizer_theme_info( $wp_customize ){
    $wp_customize->add_section( 'theme_info', array(
        'title'       => __( 'Information Links' , 'eco-travel' ),
        'priority'    => 6,
    ) );
    
    /** Important Links */
    $wp_customize->add_setting( 'theme_info_theme',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $theme_info = '<div class="customizer-custom">';
    $theme_info .= '<h3 class="sticky_title">' . __( 'Need help?', 'eco-travel' ) . '</h3>';
    $theme_info .= '<span class="sticky_info_row"><label class="row-element">' . __( 'View demo', 'eco-travel' ) . ': </label><a href="' . esc_url( 'https://rarathemes.com/previews/?theme=eco-travel/' ) . '" target="_blank">' . __( 'here', 'eco-travel' ) . '</a></span>';
    $theme_info .= '<span class="sticky_info_row"><label class="row-element">' . __( 'View documentation', 'eco-travel' ) . ': </label><a href="' . esc_url( 'https://docs.rarathemes.com/docs/travel-agency/' ) . '" target="_blank">' . __( 'here', 'eco-travel' ) . '</a></span>';
    $theme_info .= '<span class="sticky_info_row"><label class="row-element">' . __( 'Support ticket', 'eco-travel' ) . ': </label><a href="' . esc_url( 'https://rarathemes.com/support-ticket/' ) . '" target="_blank">' . __( 'here', 'eco-travel' ) . '</a></span>';
    $theme_info .= '<span class="sticky_info_row"><label class="more-detail row-element">' . __( 'More Details', 'eco-travel' ) . ': </label><a href="' . esc_url( 'https://rarathemes.com/wordpress-themes/' ) . '" target="_blank">' . __( 'here', 'eco-travel' ) . '</a></span>';
    $theme_info .= '</div>';

    $wp_customize->add_control( new Travel_Agency_Info_Text( $wp_customize,
        'theme_info_theme', 
        array(
            'label' => __( 'About Eco Travel' , 'eco-travel' ),
            'section'     => 'theme_info',
            'description' => $theme_info
        )
        )
    );
    
    /** Demo Content Import */
    $wp_customize->add_section( 
        'theme_demo_content',
        array(
            'title'    => __( 'Demo Content Import', 'eco-travel' ),
            'priority' => 7,
        )
    );
    
    $wp_customize->add_setting(
        'demo_content_instruction',
        array(
            'sanitize_callback' => 'wp_kses_post'
        )
    );

    $demo_content_description = sprintf( __( 'Eco Travel comes with demo content import feature. You can import the demo content with just one click. For step-by-step tutorial, %1$sClick here%2$s', 'eco-travel' ), '<a class="documentation" href="' . esc_url( 'https://docs.rarathemes.com/docs/faqs/theme-related/how-to-import-demo-content-using-demo-importer-plus-plugin/' ) . '" target="_blank">', '</a>' );

    $wp_customize->add_control(
        new Travel_Agency_Info_Text( 
            $wp_customize,
            'demo_content_instruction',
            array(
                'label'       => __( 'About Demo Import' , 'eco-travel' ),
                'section'     => 'theme_demo_content',
                'description' => $demo_content_description,
            )
        )
    );
    
    $theme_demo_content_desc = '<div class="customizer-custom">';

    if( ! function_exists( 'DEMO_IMPORTER_PLUS_setup' ) ){
        $theme_demo_content_desc .= '<span><label class="row-element">' . __( 'Plugin required', 'eco-travel' ) . ': </label><a href="' . esc_url( 'https://wordpress.org/plugins/demo-importer-plus/' ) . '" target="_blank">' . __( 'Demo Importer Plus', 'eco-travel' ) . '</a></span><br />';
    }

    $theme_demo_content_desc .= '</div>';
    $wp_customize->add_setting( 
        'theme_demo_content_info',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );

    // Demo content 
    $wp_customize->add_control( 
        new Travel_Agency_Info_Text( 
            $wp_customize,
            'theme_demo_content_info',
            array(
                'section'     => 'theme_demo_content',
                'description' => $theme_demo_content_desc,
            )
        )
    );

}
add_action( 'customize_register', 'eco_travel_customizer_theme_info' );


/**
 * Prints Time
*/
/**
 * Prints phone number in header
*/
function eco_travel_get_header_phone(){
    return esc_html( get_theme_mod( 'phone', '' ) );
}

/**
 * Prints phone label
*/
function eco_travel_get_phone_label(){
    return esc_html( get_theme_mod( 'phone_label', '' ) );
}

/**
 * Selective refresh for header email 
 */
function eco_travel_get_email(){
    return esc_html( get_theme_mod( 'email', '' ) );
}

/**
 * Selective refresh for banner button 
 */
function eco_travel_btn_label_selective_refresh(){
    return esc_html( get_theme_mod( 'banner_btn_label', esc_html__( 'Get Started', 'eco-travel') ) );
}

/**
 * Prints Time
*/
function eco_travel_get_time(){
    return esc_html( get_theme_mod( 'time', '' ) );
}

/**
 * Header Time
*/
function eco_travel_header_time(){
    $time = get_theme_mod( 'time' );
    if( $time ) echo '<div class="opening-time"><i class="fa fa-clock-o"></i><span class="time">' . esc_html( $time ) . '</span></div>';
}

/**
 * Header Email
*/
function eco_travel_header_email(){
    $email = get_theme_mod( 'email', '' );
    if( is_email( $email ) ) echo '<a href="' . esc_url( 'mailto:' .  $email ) . '" class="email-link"><i class="fa fa-envelope-open-o"></i><span class="email">' . esc_html( $email ) . '</span></a>';
}

/**
 * Add filter only if function exists
 */
if (function_exists('DEMO_IMPORTER_PLUS_setup')) {
    add_filter(
        'demo_importer_plus_api_url',
        function () {
            return 'https://rarathemesdemo.com/';
        }
    );
}

/**
 * Add filter only if function exists
 */
if (function_exists('DEMO_IMPORTER_PLUS_setup')) {
    add_filter(
        'demo_importer_plus_api_id',
        function () {
            return array( '2871' );
        }
    );
}

require get_stylesheet_directory() . '/inc/customizer-functions.php';

require get_stylesheet_directory() . '/inc/pluggable-functions.php';