<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Echoes
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-container">

		<header class="entry-header">
			<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		</header><!-- .entry-header -->

		<?php if ( 'post' === get_post_type() ) : ?>
			<p class="entry-meta">
				<?php echoes_posted_on(); ?>
			</p><!-- .entry-meta -->
		<?php endif; ?>

		<div class="card">
			<?php if ( has_post_thumbnail() ) :  ?>
  				<div class="img-container">
					<?php
					$archive_image           = echoes_get_option( 'archive_image' );
					$archive_image_alignment = echoes_get_option( 'archive_image_alignment' );
					
					if ( 'disable' !== $archive_image ) : ?>
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail( esc_attr( $archive_image ), array( 'class' => 'post-thumbnail' ) ); ?>
						</a>
					<?php endif; ?>
	  			</div>
			<?php endif; ?>	  
  			<div class="card-content">
     			<p class="excerpt">
					<?php the_excerpt(); echo '<a class="more-link" href="'. get_permalink() . '">Read More</a>'; ?>
                        <div class="clear"></div>
				</p>
   			</div>
		</div>

		<footer class="entry-footer">
			<?php echoes_entry_footer(); ?>
		</footer><!-- .entry-footer -->
	</div><!-- .entry-container -->
</article><!-- #post-## -->
