<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Echoes
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-container">
		<h2 class="entry-title" style="margin-top: 0"><?php the_title (); ?></h2>
		<?php if ( is_singular( 'post' ) ) : ?>
	        <p class="entry-meta">
        	<?php echoes_posted_on(); ?>
	        </p><!-- .entry-meta -->
        <?php endif ?>

		<div class="entry-content">
			
			<?php the_content(); ?>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'echoes' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
	</div><!-- .entry-container -->
	
	<footer class="entry-footer">
		<?php echoes_entry_footer(); ?>
	</footer><!-- .entry-footer -->
	<?php
		/**
		 * Hook - echoes_author_bio.
		 *
		 * @hooked echoes_add_author_bio_in_single -  10
		 */
		do_action( 'echoes_author_bio' );
	?>

</article><!-- #post-## -->

