<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Echoes
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-container">
		<h2 class="entry-title" style="margin-top: 0"><?php the_title (); ?></h2>
		<div class="entry-content">
	    <?php
		  /**
		   * Hook - echoes_single_image.
		   *
		   * @hooked echoes_add_image_in_single_display -  10
		   */
		  do_action( 'echoes_single_image' );
		?>
			<?php the_content(); ?>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'echoes' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
	</div><!-- .entry-container -->

	<footer class="entry-footer">
		<?php edit_post_link( esc_html__( 'Edit', 'echoes' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->

