<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Echoes
 */

get_header(); ?>

<div class="container">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="single-post-wrapper">
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'template-parts/content', 'single' ); ?>

					<?php the_post_navigation(
							array(
								'next_text' => '<span class="meta-nav">' . esc_html__( 'Next', 'echoes' ) . '</span><span class="post-title">%title</span>',
								'prev_text' => '<span class="meta-nav">' . esc_html__( 'Previous', 'echoes' ) . '</span><span class="post-title">%title</span>',
							)
						); ?>

					<?php
						// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
						endif;
					?>

				<?php endwhile; // End of the loop. ?>
			</div><!-- .blog-posts -->
		</main><!-- #main -->
	</div><!-- #primary -->

	<?php
		/**
		 * Hook - echoes_action_sidebar.
		 *
		 * @hooked: echoes_add_sidebar - 10
		 */
		do_action( 'echoes_action_sidebar' );
	?>
</div><!-- .container -->
<?php get_footer(); ?>
