<?php
/**
 * Functions related to customizer and options.
 *
 * @package Echoes
 */

if ( ! function_exists( 'echoes_get_page_layout_options' ) ) :

	/**
	 * Returns Page or Post layout and pagination options.
	 *
	 * @since 1.0
	 *
	 * @return array Options array.
	 */
	function echoes_get_page_layout_options() {

		$choices = array(
			'left-sidebar'  => esc_html__( 'Left Sidebar - Content', 'echoes' ),
			'right-sidebar' => esc_html__( 'Content - Right Sidebar', 'echoes' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'echoes' ),
		);
		$output = apply_filters( 'echoes_filter_layout_options', $choices );
		return $output;

	}

endif;

if ( ! function_exists( 'echoes_get_pagination_type_options' ) ) :

	/**
	 * Returns pagination type options.
	 *
	 * @since 1.0
	 *
	 * @return array Options array.
	 */
	function echoes_get_pagination_type_options() {

		$choices = array(
			'default' => esc_html__( 'Older/Newer Post', 'echoes' ),
			'numeric' => esc_html__( 'Numeric Pagination', 'echoes' ),
		);
		return $choices;

	}

endif;

