<?php
/**
 * Theme functions related to structure.
 *
 * This file contains structural hook functions.
 *
 * @package Echoes
 */

if ( ! function_exists( 'echoes_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since 1.0
	 */
	function echoes_doctype() {
	?><!DOCTYPE html><html <?php language_attributes(); ?>><?php
	}
endif;

add_action( 'echoes_action_doctype', 'echoes_doctype', 10 );


if ( ! function_exists( 'echoes_head' ) ) :
	/**
	 * Header Codes.
	 *
	 * @since 1.0
	 */
	function echoes_head() {
	?>
	    <meta charset="<?php bloginfo( 'charset' ); ?>">
	    <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="profile" href="http://gmpg.org/xfn/11">
	    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	    <?php endif; ?>
    <?php
	}
endif;
add_action( 'echoes_action_head', 'echoes_head', 10 );

if ( ! function_exists( 'echoes_page_start' ) ) :
	/**
	 * Page Start.
	 *
	 * @since 1.0
	 */
	function echoes_page_start() {
	?>
    <div id="page" class="hfeed site">
    <?php
	}
endif;
add_action( 'echoes_action_before', 'echoes_page_start' );

if ( ! function_exists( 'echoes_content_start' ) ) :
	/**
	 * Content Start.
	 *
	 * @since 1.0
	 */
	function echoes_content_start() {
	?><div id="content" class="site-content"><?php
	}
endif;
add_action( 'echoes_action_before_content', 'echoes_content_start' );


if ( ! function_exists( 'echoes_content_end' ) ) :
	/**
	 * Content End.
	 *
	 * @since 1.0
	 */
	function echoes_content_end() {
	?></div><!-- #content --><?php
	}
endif;
add_action( 'echoes_action_after_content', 'echoes_content_end' );


if ( ! function_exists( 'echoes_header_start' ) ) :
	/**
	 * Header Start.
	 *
	 * @since 1.0
	 */
	function echoes_header_start() {
		?><header id="masthead" class="site-header" role="banner"><div class="container"><?php
	}
endif;
add_action( 'echoes_action_before_header', 'echoes_header_start' );

if ( ! function_exists( 'echoes_header_end' ) ) :
	/**
	 * Header End.
	 *
	 * @since 1.0
	 */
	function echoes_header_end() {
	?></div><!-- .container --></header><!-- #masthead --><?php
	}
endif;
add_action( 'echoes_action_after_header', 'echoes_header_end' );



if ( ! function_exists( 'echoes_footer_start' ) ) :
	/**
	 * Footer Start.
	 *
	 * @since 1.0
	 */
	function echoes_footer_start() {
		$footer_status = apply_filters( 'echoes_filter_footer_status', true );
		if ( true !== $footer_status ) {
			return;
		}
		?><footer id="colophon" class="site-footer" role="contentinfo"><?php
	}
endif;
add_action( 'echoes_action_before_footer', 'echoes_footer_start' );


if ( ! function_exists( 'echoes_footer_end' ) ) :
	/**
	 * Footer End.
	 *
	 * @since 1.0
	 */
	function echoes_footer_end() {
		$footer_status = apply_filters( 'echoes_filter_footer_status', true );
		if ( true !== $footer_status ) {
			return;
		}
		?></footer><!-- #colophon -->
		<?php
	}
endif;
add_action( 'echoes_action_after_footer', 'echoes_footer_end' );
