<?php
/**
 * Default theme options.
 *
 * @package Echoes
 */

if ( ! function_exists( 'echoes_get_default_theme_options' ) ) :

	/**
	 * Get default theme options
	 *
	 * @since 1.0
	 *
	 * @return array Default theme options.
	 */
	function echoes_get_default_theme_options() {

		$defaults = array();

		// Header.
		$defaults['show_title']   = true;
		$defaults['show_tagline'] = true;

		// Layout.
		$defaults['page_layout']           = 'right-sidebar';
		$defaults['archive_layout']          = 'excerpt';

		// Pagination.
		$defaults['pagination_type'] = 'numeric';

		// Footer.
		$defaults['copyright_text']          = esc_html__( 'Copyright &copy; All rights reserved.', 'echoes' );

		// Excerpt 
		$defaults['excerpt_length'] = '45';

		// Pass through filter.
		$defaults = apply_filters( 'echoes_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
