<?php
/**
 * Theme Customizer.
 *
 * @package Echoes
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @since 1.0
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function echoes_customize_register( $wp_customize ) {

	// Load customize helpers.
	require get_template_directory() . '/inc/layout-option.php';

	// Load customize sanitize.
	require get_template_directory() . '/inc/customizer/sanitize.php';

	// Load customize callback.
	require get_template_directory() . '/inc/customizer/callback.php';

	// Load customize option.
	require get_template_directory() . '/inc/customizer/option.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

}
add_action( 'customize_register', 'echoes_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 *
 * @since 1.0
 */
function echoes_customize_preview_js() {

	wp_enqueue_script( 'echoes-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '1.1', true );

}
add_action( 'customize_preview_init', 'echoes_customize_preview_js' );

/**
 * Enqueue styles on customizer preview.
 */
function echoes_customizer_styles() {
	if ( is_customize_preview() ) {
		// Add custom css for customizer
		wp_enqueue_style( 'echoes-customizer', get_template_directory_uri() . '/assets/css/customizer.css' );
	}
}
add_action( 'customize_controls_print_styles', 'echoes_customizer_styles' );


