<?php
/**
 * Core functions.
 *
 * @package Echoes
 */

/**
 * Get theme option.
 *
 * @since 1.0
 *
 * @param string $key Option key.
 * @return mixed Option value.
 */
function echoes_get_option( $key = '' ) {

	global $echoes_default_options;
	if ( empty( $key ) ) {
		return;
	}

	$default = ( isset( $echoes_default_options[ $key ] ) ) ? $echoes_default_options[ $key ] : '';
	$theme_options = get_theme_mod( 'theme_options', $echoes_default_options );
	$theme_options = array_merge( $echoes_default_options, $theme_options );
	$value = '';
	if ( isset( $theme_options[ $key ] ) ) {
		$value = $theme_options[ $key ];
	}
	return $value;

}
