<?php
/**
 * Displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Echoes
 */

/**
 * Hook - echoes_action_doctype.
 *
 * @hooked echoes_doctype -  10
 */
do_action( 'echoes_action_doctype' );
?>
<head>
	<?php
	/**
	 * Hook - echoes_action_head.
	 *
	 * @hooked echoes_head -  10
	 */
	do_action( 'echoes_action_head' );
	?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	/**
	 * Hook - echoes_action_before.
	 *
	 * @hooked echoes_page_start - 10
	 * @hooked echoes_skip_to_content - 15
	 */
	do_action( 'echoes_action_before' );
	?>

    <?php
	  /**
	   * Hook - echoes_action_before_header.
	   *
	   * @hooked echoes_header_start - 10
	   */
	  do_action( 'echoes_action_before_header' );

		/**
		 * Hook - echoes_action_header.
		 *
		 * @hooked echoes_site_branding - 10
		 */
		do_action( 'echoes_action_header' );

	/**
	* Hook - echoes_action_after_header.
	* @hooked echoes_header_end - 10
	* @hooked echoes_add_primary_navigation - 20
	*/
	do_action( 'echoes_action_after_header' );

	/**
	 * Hook - echoes_action_before_content.
	 *
	 * @hooked echoes_add_breadcrumb - 7
	 * @hooked echoes_content_start - 10
	 */
	do_action( 'echoes_action_before_content' );

	/**
	* Hook - echoes_action_content.
	*/
	do_action( 'echoes_action_content' );

