<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Doly Lite
 */

?>
<div class="col-lg-4">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( has_post_thumbnail () ): ?>
		<div class="blog-post">
			<div class="blog-img banner-hover">
				<?php doly_post_thumbnail(); ?>
				<span class="date-time"> 
					<?php doly_lite_posted_on(); ?>
				</span> 
			</div>
			<?php endif; ?>
			<div class="blog-post-content <?php if ( ! has_post_thumbnail () ): ?>no-thumbnail<?php endif; ?>">
				<?php the_title( '<a class="blog-title" href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' ); ?>
				<div class="blog-desc">
					<p><?php echo wp_trim_words(get_the_excerpt(), 7); ?></p>
				</div>
				<?php echo'<a href="'.esc_url ( get_the_permalink( $post->ID ) ).'" class="btn btn-style2">'.esc_html__('Read More','doly-lite').'</a>'; ?>
			</div> 
		<?php if ( has_post_thumbnail () ): ?>
		</div>
		<?php endif; ?>
	</article>
</div>