<?php
/**
 * Define Theme Version
 */
define( 'COLORFLOW_THEME_VERSION', '6.0' );

function colorflow_css() {
	$parent_style = 'gradiant-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'colorflow-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('colorflow-color-default',get_stylesheet_directory_uri() .'/assets/css/color/default.css');
	wp_dequeue_style('gradiant-default');
	
	wp_enqueue_script('colorflow-custom-js', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), false, true);

}
add_action( 'wp_enqueue_scripts', 'colorflow_css',999);

function colorflow_setup()	{	
	add_theme_support( 'woocommerce' );
	add_theme_support( "title-tag" );
	add_theme_support( 'automatic-feed-links' );
	
}
add_action( 'after_setup_theme', 'colorflow_setup' );

function colorflow_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'gradiant_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'gradiant_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'colorflow_custom_header_setup' );

/**
 * Dynamic Styles
 */
if( ! function_exists( 'colorflow_dynamic_style' ) ):
    function colorflow_dynamic_style() {

		$output_css = '';
		
			
		 /**
		 *  Breadcrumb Style
		 */
		$colorflow_hs_breadcrumb	= get_theme_mod('hs_breadcrumb','1');	
		
		if($colorflow_hs_breadcrumb == '') { 
				$output_css .=".gradiant-content {
					padding-top: 200px;
				}\n";
			}
		
		
		/**
		 *  Parallax
		 */
		$colorflow_footer_parallax_enable	= get_theme_mod('footer_parallax_enable','1');	
		$colorflow_footer_parallax_margin	= get_theme_mod('footer_parallax_margin','775');	
		
		if($colorflow_footer_parallax_enable =='1'):
			 $output_css .="@media (min-width: 992px){.footer-parallax #content.gradiant-content { 
					 margin-bottom: ".esc_attr($colorflow_footer_parallax_margin)."px;
			 }}\n";	
		endif; 	
		
        wp_add_inline_style( 'colorflow-style', $output_css );
    }
endif;
add_action( 'wp_enqueue_scripts', 'colorflow_dynamic_style',999);


/**
 * Called all the Customize file.
 */
require( get_stylesheet_directory() . '/inc/customize/colorflow-premium.php');

/**
 * Import Options From Parent Theme
 *
 */
function colorflow_parent_theme_options() {
	$gradiant_mods = get_option( 'theme_mods_gradiant' );
	if ( ! empty( $gradiant_mods ) ) {
		foreach ( $gradiant_mods as $gradiant_mod_k => $gradiant_mod_v ) {
			set_theme_mod( $gradiant_mod_k, $gradiant_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'colorflow_parent_theme_options' );