<?php
/**
 * Template part for displaying WooCommerce content in page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package colon
 */

$enable_shop_sidebar = get_theme_mod('colon_enable_shop_sidebar', true);
$sidebar_layout = esc_html(get_theme_mod('colon_woo_sidebar_layout', 'right'));
$is_sidebar_active = is_active_sidebar('woosidebar');
?>

<div class="row">
	<?php if ($enable_shop_sidebar && $is_sidebar_active): ?>
		<?php if ('right' === $sidebar_layout): ?>
			<div class="col-md-9">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="entry-content">
						<div class="woocommerce">
							<?php woocommerce_content(); ?>
						</div>
					</div>
				</article>
			</div>
			<div class="col-md-3">
				<div class="woo-sidebar">
					<div class="entry-content">
						<div class="woocommerce">
							<?php get_sidebar('woosidebar'); ?>
						</div>
					</div>
				</div>
			</div>
		<?php elseif ('left' === $sidebar_layout): ?>
			<div class="col-md-3">
				<div class="woo-sidebar">
					<div class="entry-content">
						<div class="woocommerce">
							<?php get_sidebar('woosidebar'); ?>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-9">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="entry-content">
						<div class="woocommerce">
							<?php woocommerce_content(); ?>
						</div>
					</div>
				</article>
			</div>
		<?php endif; ?>
	<?php else: ?>
		<div class="col-md-12">
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="entry-content">
					<div class="woocommerce">
						<?php woocommerce_content(); ?>
					</div>
				</div>
			</article>
		</div>
	<?php endif; ?>
</div>
