<?php
/**
 * Template part for displaying cart page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package colon
 */

// Function to render the page content
function colon_render_page_content() {
    ?>
    <div class="content-page">
        <div class="page-content-area">
            <div class="entry-content">
                <?php
                    the_content();
                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'colon' ),
                        'after'  => '</div>',
                    ) );
                ?>
            </div><!-- .entry-content -->
            <footer class="entry-footer">
                <?php
                    edit_post_link(
                        sprintf(
                            /* translators: %s: Name of current post */
                            esc_html__( 'Edit %s', 'colon' ),
                            the_title( '<span class="screen-reader-text">"', '"</span>', false )
                        ),
                        '<span class="edit-link">',
                        '</span>'
                    );
                ?>
            </footer><!-- .entry-footer -->
        </div>
    </div>
    <?php
}

// Function to render sidebar if active
function colon_render_sidebar() {
    if ( is_active_sidebar('page-sidebar') ) :
        get_sidebar('page-sidebar');
    endif;
}

?>

<?php if ( true === get_theme_mod( 'colon_enable_page_sidebar', false ) ) : ?>
    <div class="container">
        <?php if ( 'right' === esc_html( get_theme_mod( 'colon_page_sidebar_layout', 'no' ) ) && ! is_front_page() ) : ?>
            <div class="row">
                <div id="page-wrapper" class="col-md-9">
                    <?php colon_render_page_content(); ?>
                </div>
                <div id="sidebar-wrapper" class="col-md-3">
                    <?php colon_render_sidebar(); ?>
                </div>
            </div>
        <?php elseif ( 'left' === esc_html( get_theme_mod( 'colon_page_sidebar_layout', 'no' ) ) && ! is_front_page() ) : ?>
            <div class="row">
                <div id="sidebar-wrapper" class="col-md-3">
                    <?php colon_render_sidebar(); ?>
                </div>
                <div id="page-wrapper" class="col-md-9">
                    <?php colon_render_page_content(); ?>
                </div>
            </div>
        <?php else : ?>
            <div class="row">
                <div id="page-wrapper" class="col-md-12">
                    <?php colon_render_page_content(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php else : ?>
    <div class="container">
        <div id="page-wrapper" class="col-md-12">
            <?php colon_render_page_content(); ?>
        </div>
    </div>
<?php endif; ?>
