<?php
/**
 * Template part for displaying cart page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package colon
 */

// Get sidebar layout option
$sidebar_layout = esc_html(get_theme_mod('colon_cart_page_sidebar_layout', 'no'));

// Check if the sidebar is active
$sidebar_active = is_active_sidebar('woosidebar');

// Start container
echo '<div class="container">';

// Check layout and render the appropriate layout
if ($sidebar_layout !== 'no' && $sidebar_active) :
    // Render Sidebar and Content based on layout setting
    $sidebar_class = $sidebar_layout === 'right' ? 'col-md-3' : 'col-md-3';
    $content_class = $sidebar_layout === 'right' ? 'col-md-9' : 'col-md-9';

    echo '<div id="sidebar-wrapper" class="' . $sidebar_class . '">';
    get_sidebar('woosidebar');
    echo '</div>';

    echo '<div id="cart-wrapper" class="' . $content_class . '">';
    colon_render_page_content();
    echo '</div>';
else :
    // Render full width content when no sidebar
    echo '<div id="cart-wrapper" class="col-md-12">';
    colon_render_page_content();
    echo '</div>';
endif;

// End container
echo '</div>';

/**
 * Renders the page content with post navigation and edit post link.
 */
function colon_render_page_content() {
    ?>
    <div class="content-page">
        <div class="page-content-area">
            <div class="entry-content">
                <?php
                    the_content();
                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'colon' ),
                        'after'  => '</div>',
                    ) );
                ?>
            </div><!-- .entry-content -->
            <footer class="entry-footer">
                <?php
                    edit_post_link(
                        sprintf(
                            /* translators: %s: Name of current post */
                            esc_html__( 'Edit %s', 'colon' ),
                            the_title( '<span class="screen-reader-text">"', '"</span>', false )
                        ),
                        '<span class="edit-link">',
                        '</span>'
                    );
                ?>
            </footer><!-- .entry-footer -->
        </div>
    </div>
    <?php
}
?>
