<?php
/**
 * Footer widget template for Colon theme.
 *
 * @package colon
 */

// Return early if the first widget area is inactive.
if (!is_active_sidebar('footer-1')) {
    return;
}

// Get the user-selected widget columns setting.
$colon_widget_num = esc_html(get_theme_mod('colon_footer_widgets', '4'));

// Define column classes based on the widget layout setting.
$widget_classes = get_footer_widget_classes($colon_widget_num);

/**
 * Helper function to return column classes for widget areas.
 *
 * @param string $widget_num Selected widget layout.
 * @return array Column classes for each widget.
 */
function get_footer_widget_classes($widget_num) {
    switch ($widget_num) {
        case '3-wide':
            return ['col-md-3', 'col-md-3', 'col-md-6 align-right'];
        case '4':
            return ['col-md-3', 'col-md-3', 'col-md-3', 'col-md-3'];
        case '3':
            return ['col-md-4', 'col-md-4', 'col-md-4'];
        case '2':
            return ['col-md-6', 'col-md-6'];
        default:
            return ['col-md-12'];
    }
}

// Render dynamic widget areas.
for ($i = 1; $i <= count($widget_classes); $i++) {
    if (is_active_sidebar('footer-' . $i)) {
        ?>
        <div class="widget-column <?php echo esc_attr($widget_classes[$i - 1]); ?>">
            <?php dynamic_sidebar('footer-' . $i); ?>
        </div>
        <?php
    }
}
?>
