<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 * @package colon
 */

get_header();

colon_before_title();
do_action('colon_get_page_title', false, false, true, false);
colon_after_title();
?>

<div id="primary" class="<?php echo esc_attr(get_theme_mod('colon_header_menu_style', 'style1')); ?> content-area">
	<main id="main" class="site-main colon-main" role="main">
		<div class="content-blog searchpage">
			<div class="container">
				<div class="row">
					<?php
					$sidebar_layout = esc_html(get_theme_mod('colon_blog_sidebar_layout', 'right'));
					$sidebar_active = is_active_sidebar('sidebar-1');

					// Sidebar on the right
					if ($sidebar_active && $sidebar_layout === 'right') :
						render_sidebar_content('right');
					// Sidebar on the left
					elseif ($sidebar_active && $sidebar_layout === 'left') :
						render_sidebar_content('left');
					// No Sidebar
					else :
						render_content_area('col-md-12');
					endif;

					/**
					 * Renders content with or without sidebars.
					 */
					function render_sidebar_content($sidebar_position) {
						$content_class = $sidebar_position === 'right' ? 'col-md-9' : 'col-md-9';
						$sidebar_class = 'col-md-3';
						?>
						<?php if ($sidebar_position === 'left') : ?>
							<div class="<?php echo esc_attr($sidebar_class); ?>">
								<?php get_sidebar('sidebar-1'); ?>
							</div>
						<?php endif; ?>
						<div class="<?php echo esc_attr($content_class); ?>">
							<?php render_search_results(); ?>
						</div>
						<?php if ($sidebar_position === 'right') : ?>
							<div class="<?php echo esc_attr($sidebar_class); ?>">
								<?php get_sidebar('sidebar-1'); ?>
							</div>
						<?php endif;
					}

					/**
					 * Renders the search results area.
					 */
					function render_content_area($class) {
						?>
						<div class="<?php echo esc_attr($class); ?>">
							<?php render_search_results(); ?>
						</div>
						<?php
					}

					/**
					 * Displays search results or a fallback if no results are found.
					 */
					function render_search_results() {
						if (have_posts()) : ?>
							<div class="search-content">
								<h1 class="page-search">
									<?php printf(esc_html__('Search Results for: %s', 'colon'), '<span>' . get_search_query() . '</span>'); ?>
								</h1>
							</div>
							<?php while (have_posts()) : the_post();
								get_template_part('template-parts/post/content', 'search');
							endwhile;
							the_posts_navigation();
						else :
							get_template_part('template-parts/post/content', 'none');
						endif;
					}
					?>
				</div>
			</div>
		</div>
	</main>
</div>

<?php get_footer(); ?>
