<?php
/**
 * Template for displaying comments.
 *
 * @package colon
 */

if ( post_password_required() ) {
    return;
}

/**
 * Custom callback for displaying comments.
 */
function colon_comment_callback( $comment, $args, $depth ) {
    $tag = ( 'div' === $args['style'] ) ? 'div' : 'li';
    ?>
    <<?php echo esc_html( $tag ); ?> id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
        <article id="div-comment-<?php comment_ID(); ?>" class="comment-body" itemscope itemtype="https://schema.org/UserComments">
            <footer class="comment-meta">
                <div class="comment-author vcard">
                    <?php
                    if ( $args['avatar_size'] ) {
                        echo get_avatar( $comment, $args['avatar_size'], '', esc_attr__( "User Image", "colon" ) );
                    }
                    printf(
                        '<b class="fn" itemprop="creator">%s</b> <span class="says">%s</span>',
                        get_comment_author_link( $comment ),
                        esc_html__( 'says:', 'colon' )
                    );
                    ?>
                </div>

                <div class="comment-metadata">
                    <a href="<?php echo esc_url( get_comment_link( $comment, $args ) ); ?>">
                        <time itemprop="commentTime" datetime="<?php comment_time( 'c' ); ?>">
                            <?php printf( esc_html__( '%1$s at %2$s', 'colon' ), get_comment_date( '', $comment ), get_comment_time() ); ?>
                        </time>
                    </a>
                    <?php edit_comment_link( esc_html__( 'Edit', 'colon' ), '<span class="edit-link">', '</span>' ); ?>
                </div>

                <?php if ( '0' == $comment->comment_approved ) : ?>
                    <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'colon' ); ?></p>
                <?php endif; ?>
            </footer>

            <div class="comment-content" itemprop="commentText">
                <?php comment_text(); ?>
            </div>

            <?php
            comment_reply_link( array_merge( $args, array(
                'add_below' => 'comment',
                'depth'     => $depth,
                'max_depth' => $args['max_depth'],
                'before'    => '<div class="reply">',
                'after'     => '</div>',
            ) ) );
            ?>
        </article>
    </<?php echo esc_html( $tag ); ?>>
    <?php
}
?>

<div id="comments" class="comments-area">
    <?php if ( have_comments() ) : ?>
        <h3 class="comments-title">
            <?php
            printf(
                esc_html( _nx( '%1$s person reacted on this', '%1$s people reacted on this', get_comments_number(), 'comments title', 'colon' ) ),
                number_format_i18n( get_comments_number() )
            );
            ?>
        </h3>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="navigation comment-navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'colon' ); ?></h2>
                <div class="nav-links">
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'colon' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'colon' ) ); ?></div>
                </div>
            </nav>
        <?php endif; ?>

        <ol class="comment-list">
            <?php wp_list_comments( array(
                'style'       => 'ol',
                'short_ping'  => true,
                'avatar_size' => 50,
                'callback'    => 'colon_comment_callback',
            ) ); ?>
        </ol>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="navigation comment-navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'colon' ); ?></h2>
                <div class="nav-links">
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'colon' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'colon' ) ); ?></div>
                </div>
            </nav>
        <?php endif; ?>
    <?php endif; ?>

    <?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'colon' ); ?></p>
    <?php endif; ?>

    <?php
    comment_form( array(
        'comment_field'         => '<p class="comment-form-comment"><label for="comment" class="screen-reader-text">' . esc_html__( 'Comment', 'colon' ) . '</label><textarea id="comment" name="comment" cols="45" rows="8" required></textarea></p>',
        'title_reply'           => esc_html__( 'Leave a Comment', 'colon' ),
        'label_submit'          => esc_html__( 'Post Comment', 'colon' ),
        'comment_notes_before'  => '',
        'comment_notes_after'   => '',
    ) );
    ?>
</div>
