<?php
/**
 * The template for displaying author archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package colon
 */

get_header();
colon_before_title();
?>
<div class="page-title">
    <?php colon_before_title_content(); ?>
    <div class="container">
        <?php $curauth = get_queried_object(); ?>
        <h1 class="main-title">
            <span><?php esc_html_e('Author: ', 'colon'); ?></span>
            <?php echo esc_html($curauth->display_name); ?>
        </h1>
        <?php if (get_theme_mod('colon_enable_page_breadcrumbs', true)) :
            do_action('colon_breadcrumbs_hook');
        endif; ?>
    </div>
    <?php colon_after_title_content(); ?>
</div>
<?php colon_after_title(); ?>

<div id="primary" class="<?php echo esc_attr(get_theme_mod('colon_header_menu_style', 'style1')); ?> content-area">
    <main id="main" class="site-main colon-main" role="main">
        <div class="container">
            <div id="blog-section">
                <div class="row">
                    <?php
                    $sidebar_layout = esc_html(get_theme_mod('colon_blog_sidebar_layout', 'right'));
                    $has_sidebar = is_active_sidebar('sidebar-1');
                    $main_class = $has_sidebar ? 'col-md-9' : 'col-md-12';
                    $sidebar_class = 'col-md-3';

                    if ($has_sidebar && $sidebar_layout === 'left') :
                        echo "<div class='{$sidebar_class}'>";
                        get_sidebar('sidebar-1');
                        echo '</div>';
                    endif;
                    ?>
                    <div class="<?php echo esc_attr($main_class); ?>">
                        <?php if (have_posts()) :
                            while (have_posts()) : the_post();
                                get_template_part('template-parts/post/content-archive', get_post_format());
                            endwhile; ?>
                            <nav class="pagination">
                                <?php the_posts_pagination(); ?>
                            </nav>
                        <?php endif; ?>
                    </div>
                    <?php if ($has_sidebar && $sidebar_layout === 'right') : ?>
                        <div class="<?php echo esc_attr($sidebar_class); ?>">
                            <?php get_sidebar('sidebar-1'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>

<?php get_footer(); ?>
