<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package colon
 */

get_header();
colon_before_title();
do_action('colon_get_page_title', false, false, false, true);
colon_after_title();

?>

<div id="primary" class="<?php echo esc_attr(get_theme_mod('colon_header_menu_style', 'style1')); ?> content-area">
	<main id="main" class="site-main colon-main" role="main">
		<div class="content-page">
			<div class="container">
				<div class="row">
					<?php
					// Default content block
					$content_block = '
						<div class="page-content-area">	
							<h1 class="page-error">' . esc_html__('Oops! That page can&rsquo;t be found.', 'colon') . '</h1>
							<p>' . esc_html__('It looks like nothing was found at this location. Maybe try one of the links on right or a search?', 'colon') . '</p>
							' . get_search_form(false) . '
						</div>';

					$sidebar_position = esc_html(get_theme_mod('colon_blog_sidebar', 'right'));

					if (is_active_sidebar('sidebar-1')) :
						switch ($sidebar_position) {
							case 'right':
								echo '<div class="col-md-8">' . $content_block . '</div>';
								echo '<div class="col-md-3 col-md-offset-1">';
								get_sidebar('sidebar-1');
								echo '</div>';
								break;
							case 'left':
								echo '<div class="col-md-3">';
								get_sidebar('sidebar-1');
								echo '</div>';
								echo '<div class="col-md-8 col-md-offset-1">' . $content_block . '</div>';
								break;
							default:
								echo '<div class="col-md-12">' . $content_block . '</div>';
								break;
						}
					else:
						echo '<div class="col-md-12">' . $content_block . '</div>';
					endif;
					?>
				</div>
			</div>
		</div>
	</main>
</div>

<?php
get_footer();
