<?php

function clean_charity_get_homepage_services(){

	ob_start();

	$clean_charity_services = bizberg_get_theme_mod( 'clean_charity_services' );
	$clean_charity_services = json_decode( $clean_charity_services, true );

	foreach( $clean_charity_services as $value ){ 

		$icon    = !empty( $value['icon'] ) ? $value['icon'] : '';
		$page_id = !empty( $value['page_id'] ) ? $value['page_id'] : ''; ?>

		<div class="column">
		
			<span class="icon">
				<i class="<?php echo esc_attr( $icon ); ?>"></i>
			</span>

			<?php 
			if( !empty( $page_id ) ){

				$services_post = get_post( $page_id ); ?>
				<h3><?php echo esc_html( $services_post->post_title ); ?></h3>
				<p><?php echo esc_html( wp_trim_words( sanitize_text_field( $services_post->post_content ), 20, ' [...]' ) ); ?></p>

				<?php 
			} ?>

		</div>

		<?php 

	} 

	return ob_get_clean();

}

add_action( 'bizberg_before_homepage_blog', 'clean_charity_homepage_services' );
function clean_charity_homepage_services(){

	$clean_charity_services = bizberg_get_theme_mod( 'clean_charity_services' );
	$clean_charity_services = json_decode( $clean_charity_services, true );

	if( empty( $clean_charity_services ) ){
		return;
	} ?>

	<div class="clean_charity_services_wrapper">

		<div class="container">

			<div class="clean_charity_services_inner_wrapper">

				<?php 
				echo wp_kses_post( clean_charity_get_homepage_services() );
				?>

			</div>

		</div>

	</div>

	<?php
}