<?php 

add_action( 'bizberg_before_homepage_blog', 'clean_charity_homepage_call_to_action' );
function clean_charity_homepage_call_to_action(){ 

	$page_id           = bizberg_get_theme_mod( 'call_to_action_page_id' ); 
	$button_text       = bizberg_get_theme_mod( 'call_to_action_button_text' );
	$button_link       = bizberg_get_theme_mod( 'call_to_action_button_link' );
	$featured_image_id = get_post_thumbnail_id( $page_id );

	if( empty( $page_id ) ){
		return;
	}

	$call_to_action_object = get_post( $page_id );
	
	if( empty( $call_to_action_object ) ){
		return;
	} ?>

	<div class="call_to_action_wrapper">
		
		<div class="container">
			
			<div class="column_wrapper <?php echo empty( $featured_image_id ) ? 'no_image' : ''; ?>">
				<div 
				class="column"
				style="background-image:url(<?php echo esc_url( wp_get_attachment_url( $featured_image_id ) ); ?>);"></div>

				<div class="column content">
					<h3><?php echo esc_html( get_the_title( $page_id ) ); ?></h3>
					<p><?php echo wp_kses_post( get_the_excerpt() ); ?></p>

					<?php 
					if( !empty( $button_text ) ){ ?>
						<div class="button">
							<a href="<?php echo esc_url( $button_link ); ?>">
								<?php echo esc_html( $button_text ); ?>
							</a>
						</div>
						<?php 
					} ?>

				</div>
			</div>

		</div>

	</div>

	<?php
}