<?php

require get_stylesheet_directory() . '/customizer/options-call-to-action.php';
require get_stylesheet_directory() . '/customizer/options-services.php';
require get_stylesheet_directory() . '/sections/services.php';
require get_stylesheet_directory() . '/sections/call-to-action.php';

add_action( 'after_setup_theme', 'clean_charity_setup_theme' );
function clean_charity_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
}

add_filter( 'bizberg_banner_title', 'clean_charity_banner_title' );
function clean_charity_banner_title(){
    return current_user_can( 'edit_theme_options' ) ? esc_html__( 'Make Difference Today With Us' , 'clean-charity' ) : '';
}

add_action( 'wp_enqueue_scripts', 'clean_charity_chld_thm_parent_css' );
function clean_charity_chld_thm_parent_css() {

    wp_enqueue_style( 
    	'clean_charity_chld_css', 
    	trailingslashit( get_template_directory_uri() ) . 'style.css', 
    	array( 
    		'bootstrap',
    		'font-awesome-5',
    		'bizberg-main',
    		'bizberg-component',
    		'bizberg-style2',
    		'bizberg-responsive' 
    	) 
    );

    if ( is_rtl() ) {
        wp_enqueue_style( 
            'clean_charity_parent_rtl', 
            trailingslashit( get_template_directory_uri() ) . 'rtl.css'
        );
    }
    
}

/**
* Change the theme color
*/
add_filter( 'bizberg_theme_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover_sticky_menu', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_button_color_sticky_menu', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover_sticky_menu', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_button_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_slider_title_box_highlight_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_slider_arrow_background_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_slider_dot_active_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_read_more_background_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_read_more_background_color_2', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_link_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_link_color_hover', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_blog_listing_pagination_active_hover_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_link_color_hover', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_title_color', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_footer_social_icon_background', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_background_color_1', 'clean_charity_change_theme_color' );
add_filter( 'bizberg_background_color_2', 'clean_charity_change_theme_color' );
function clean_charity_change_theme_color(){
    return '#e0be53';
}

add_filter( 'bizberg_header_button_border_color', 'clean_charity_btn_border_color' );
add_filter( 'bizberg_header_button_border_color_sticky_menu', 'clean_charity_btn_border_color' );
function clean_charity_btn_border_color(){
    return '#c1970f';
}

add_filter( 'bizberg_slider_gradient_primary_color', 'clean_charity_slider_gradient_primary_color' );
function clean_charity_slider_gradient_primary_color(){
    return 'rgba(224,190,83,0.65)';
}

add_filter( 'bizberg_footer_social_icon_color', 'clean_charity_footer_social_icon_color' );
function clean_charity_footer_social_icon_color(){
    return '#fff';
}

add_filter( 'bizberg_banner_image', 'clean_charity_banner_image' );
function clean_charity_banner_image(){
    return [
        'background-color'      => 'rgba(20,20,20,.8)',
        'background-image'      => get_stylesheet_directory_uri() . '/assets/images/plant-flower-petal-spring-green-red-785441-pxhere.com.jpg',
        'background-repeat'     => 'repeat',
        'background-position'   => 'center center',
        'background-size'       => 'cover',
        'background-attachment' => 'scroll',
    ];
}

add_filter( 'bizberg_banner_opacity_primary_color', 'clean_charity_banner_opacity_primary_color' );
add_filter( 'bizberg_banner_opacity_secondary_color', 'clean_charity_banner_opacity_primary_color' );
function clean_charity_banner_opacity_primary_color(){
    return 'rgba(0, 0, 0, 0.3)';
}

add_filter( 'bizberg_sticky_content_sidebar' , 'clean_charity_sticky_content_sidebar' );
function clean_charity_sticky_content_sidebar(){
    return false;
}

add_filter( 'bizberg_footer_social_links' , 'clean_charity_footer_social_links' );
function clean_charity_footer_social_links(){
    return [];
}

add_filter( 'bizberg_theme_output_css', 'clean_charity_theme_output_css' );
function clean_charity_theme_output_css( $css ){
    $css[] = array(
        'element'       => '.clean_charity_services_inner_wrapper .column .icon i',
        'property'      => 'background',
        'value_pattern' => '$'
    );
    $css[] = array(
        'element'       => '.give-form input[type="submit"], .give-donor__load_more, .nacep-ee-list .event-content input[type="submit"], .nacep-form .em-tickets-form button[type=button], .nacep-form button[type="submit"], .nacep-form input[type="submit"],.nacep-form button[type="submit"]:hover, .nacep-form button[type="submit"]:focus, .give-form input[type="submit"]:hover, .give-form input[type="submit"]:focus, .give-donor__load_more:hover, .give-donor__load_more:focus, .nacep-ee-list .event-content input[type="submit"]:hover, .nacep-ee-list .event-content input[type="submit"]:focus, .nacep-form .em-tickets-form button[type=button]:hover, .nacep-form .em-tickets-form button[type=button]:focus, .nacep-form input[type="submit"]:hover, .nacep-form input[type="submit"]:focus',
        'property'      => 'background',
        'value_pattern' => '$'
    );
    return $css;
}

add_filter( 'bizberg_recommended_plugins', 'clean_charity_recommended_plugins' );
function clean_charity_recommended_plugins( $plugins ){

    array_push( $plugins , array(
        'name'     => esc_html__( 'Charity Addon for Elementor', 'clean-charity' ),
        'slug'     => 'charity-addon-for-elementor',
        'required' => false,
    ));

    array_push( $plugins , array(
        'name'     => esc_html__( 'GiveWP – Donation Plugin and Fundraising Platform', 'clean-charity' ),
        'slug'     => 'give',
        'required' => false,
    ));

    return $plugins;

}

add_filter( 'bizberg_getting_started_screenshot', 'clean_charity_getting_started_screenshot' );
function clean_charity_getting_started_screenshot(){
    return true;
}