<?php

add_action( 'init' , 'clean_charity_services' );
function clean_charity_services(){

	Kirki::add_section( 'clean_charity_services_sections', array(
        'title'   => esc_html__( 'Services', 'clean-charity' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', array(
    	'type'        => 'advanced-repeater',
    	'label'       => esc_html__( 'Services', 'clean-charity' ),
	    'section'     => 'clean_charity_services_sections',
	    'settings'    => 'clean_charity_services',
	    'partial_refresh'    => [
			'clean_charity_services' => [
				'selector'        => '.clean_charity_services_inner_wrapper',
				'render_callback' => 'clean_charity_get_homepage_services',
			],
		],
	    'choices' => [
	        'button_label' => esc_html__( 'Add Services', 'clean-charity' ),
	        'row_label' => [
	            'value' => esc_html__( 'Services', 'clean-charity' ),
	        ],
	        'fields' => [
	        	'icon'  => [
	                'type'        => 'fontawesome',
	                'label'       => esc_html__( 'Icon', 'clean-charity' ),
	                'default'     => 'fab fa-accusoft',
	                'choices'     => bizberg_get_fontawesome_options(),
	            ],
	            'page_id' => [
	                'type'        => 'select',
	                'label'       => esc_html__( 'Page', 'clean-charity' ),
	                'choices'     => bizberg_get_all_pages()
	            ],
	        ],
	    ]
    ));

}