<?php

add_action( 'init' , 'clean_charity_call_to_action' );
function clean_charity_call_to_action(){

	Kirki::add_section( 'clean_charity_call_to_action_section', array(
        'title'   => esc_html__( 'Call To Action', 'clean-charity' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
		'type'        => 'select',
		'settings'    => 'call_to_action_page_id',
		'label'       => esc_html__( 'Select Page', 'clean-charity' ),
		'section'     => 'clean_charity_call_to_action_section',
		'multiple'    => 1,
		'choices'     => bizberg_get_all_pages(),
	] );

	Kirki::add_field( 'bizberg', array(
	    'type'        => 'simple-color',
	    'label'       => esc_html__( 'Background Color', 'clean-charity' ),
	    'section'     => 'clean_charity_call_to_action_section',
	    'settings'    => 'call_to_action_background',
	    'default'     => '#e0be53',
	    'choices'     => [
	        'alpha' => true,
	    ],
	    'transport' => 'auto',
	    'output' => array(
	        array(
	            'element'  => '.call_to_action_wrapper',
	            'property' => 'background',
	        ),
	    ),
	) );

	Kirki::add_field( 'bizberg', array(
	    'type'        => 'custom',
	    'settings'    => 'homepage_call_to_action_button',
	    'section'     => 'clean_charity_call_to_action_section',
	    'default'     => '<div class="bizberg_customizer_custom_heading">' . esc_html__( 'Button Settings', 'clean-charity' ) . '</div>'
	) );

	Kirki::add_field( 'bizberg', [
		'type'     => 'text',
		'settings' => 'call_to_action_button_text',
		'label'    => esc_html__( 'Button Label', 'clean-charity' ),
		'section'  => 'clean_charity_call_to_action_section',
		'default'  => esc_html__( 'Read More', 'clean-charity' ),
	] );

	Kirki::add_field( 'bizberg', [
		'type'     => 'text',
		'settings' => 'call_to_action_button_link',
		'label'    => esc_html__( 'Button Link', 'clean-charity' ),
		'section'  => 'clean_charity_call_to_action_section',
		'default'  => esc_html__( '#', 'clean-charity' ),
	] );

}