<?php
/**
 * The template for displaying all single posts
 *
 * @package ChronoCards_Ruchir
 */

get_header(); ?>

<main id="primary" class="site-main">
	<div class="container">
		<?php
		while ( have_posts() ) :
			the_post();
			?>
			
			<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-post' ); ?>>
				<header class="entry-header">
					<?php
					if ( is_singular() ) :
						the_title( '<h1 class="entry-title">', '</h1>' );
					else :
						the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
					endif;

					if ( 'post' === get_post_type() ) :
						?>
						<div class="entry-meta">
							<span class="posted-on">
								<time class="entry-date published" datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
									<?php echo esc_html( get_the_date() ); ?>
								</time>
								<time class="updated" datetime="<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>">
									<?php echo esc_html( get_the_modified_date() ); ?>
								</time>
							</span>
							
							<span class="byline">
								<?php
								printf(
									/* translators: %s: post author. */
									esc_html_x( 'by %s', 'post author', 'chronocards-ruchir' ),
									'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
								);
								?>
							</span>
							
							<?php
							$categories_list = get_the_category_list( esc_html__( ', ', 'chronocards-ruchir' ) );
							if ( $categories_list ) {
								printf(
									/* translators: 1: list of categories. */
									'<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'chronocards-ruchir' ) . '</span>',
									wp_kses_post( $categories_list )
								);
							}
							?>
						</div>
						<?php
					endif;
					?>
				</header><!-- .entry-header -->

				<?php if ( has_post_thumbnail() ) : ?>
					<div class="post-thumbnail">
						<?php the_post_thumbnail( 'large' ); ?>
					</div>
				<?php endif; ?>

				<div class="entry-content">
					<?php
					the_content(
						sprintf(
							wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'chronocards-ruchir' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							get_the_title()
						)
					);

					wp_link_pages(
						array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'chronocards-ruchir' ),
							'after'  => '</div>',
						)
					);
					?>
				</div><!-- .entry-content -->

				<footer class="entry-footer">
					<?php
					$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'chronocards-ruchir' ) );
					if ( $tags_list ) {
						printf(
							/* translators: 1: list of tags. */
							'<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'chronocards-ruchir' ) . '</span>',
							wp_kses_post( $tags_list )
						);
					}
					?>

					<?php if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
						<span class="comments-link">
							<?php
							comments_popup_link(
								sprintf(
									wp_kses(
										/* translators: %s: post title */
										__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'chronocards-ruchir' ),
										array(
											'span' => array(
												'class' => array(),
											),
										)
									),
									get_the_title()
								)
							);
							?>
						</span>
					<?php endif; ?>

					<?php
					edit_post_link(
						sprintf(
							wp_kses(
								/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Edit <span class="screen-reader-text">%s</span>', 'chronocards-ruchir' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							get_the_title()
						),
						'<span class="edit-link">',
						'</span>'
					);
					?>
				</footer><!-- .entry-footer -->
			</article><!-- #post-<?php the_ID(); ?> -->

			<?php
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
			?>

			<?php
			the_post_navigation(
				array(
					'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'chronocards-ruchir' ) . '</span> <span class="nav-title">%title</span>',
					'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'chronocards-ruchir' ) . '</span> <span class="nav-title">%title</span>',
				)
			);
			?>

		<?php endwhile; // End of the loop. ?>
	</div><!-- .container -->
</main><!-- #primary -->

<?php
get_footer();
