<?php
/**
 * Template for displaying search forms
 *
 * @package ChronoCards_Ruchir
 */

?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php echo esc_html( _x( 'Search for:', 'label', 'chronocards-ruchir' ) ); ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search …', 'placeholder', 'chronocards-ruchir' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	</label>
	<input type="submit" class="search-submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'chronocards-ruchir' ); ?>" />
</form>
