/**
 * ChronoCards Ruchir Theme Customizer JavaScript
 */

(function($) {
    'use strict';

    // Site title and description
    wp.customize('blogname', function(value) {
        value.bind(function(to) {
            $('.site-title a').text(to);
        });
    });

    wp.customize('blogdescription', function(value) {
        value.bind(function(to) {
            $('.site-description').text(to);
        });
    });

    // Timeline line color
    wp.customize('timeline_line_color', function(value) {
        value.bind(function(to) {
            $('.timeline-line').css('background', 'linear-gradient(to bottom, ' + to + ', #e74c3c, #2ecc71, #f39c12)');
        });
    });

    // Card background color
    wp.customize('card_background_color', function(value) {
        value.bind(function(to) {
            $('.timeline-card').css('background-color', to);
        });
    });

    // Card border radius
    wp.customize('card_border_radius', function(value) {
        value.bind(function(to) {
            $('.timeline-card').css('border-radius', to + 'px');
        });
    });

    // Timeline dot size
    wp.customize('timeline_dot_size', function(value) {
        value.bind(function(to) {
            $('.timeline-dot').css({
                'width': to + 'px',
                'height': to + 'px'
            });
        });
    });

    // Site title font size
    wp.customize('site_title_font_size', function(value) {
        value.bind(function(to) {
            $('.site-title').css('font-size', to + 'rem');
        });
    });

    // Card title font size
    wp.customize('card_title_font_size', function(value) {
        value.bind(function(to) {
            $('.card-title').css('font-size', to + 'rem');
        });
    });

    // Container max width
    wp.customize('container_max_width', function(value) {
        value.bind(function(to) {
            $('.container').css('max-width', to + 'px');
        });
    });

    // Card spacing
    wp.customize('card_spacing', function(value) {
        value.bind(function(to) {
            $('.timeline-card').css('margin', to + 'px 0');
        });
    });

})(jQuery);
