<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package ChronoCards_Ruchir
 */

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function chronocards_ruchir_pingback_header() {
    if ( is_singular() && pings_open() ) {
        printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
    }
}
add_action( 'wp_head', 'chronocards_ruchir_pingback_header' );

/**
 * Add custom CSS for category colors
 */
function chronocards_ruchir_category_colors_css() {
    $colors = array(
        'tech'      => '#3498db',
        'lifestyle' => '#2ecc71',
        'business'  => '#e74c3c',
        'design'    => '#f39c12',
        'travel'    => '#9b59b6',
        'food'      => '#e67e22',
        'health'    => '#1abc9c',
        'education' => '#34495e',
    );

    $css = '';
    foreach ( $colors as $category => $color ) {
        $css .= ".category-{$category} .timeline-dot,
                 .category-{$category} .card-category {
                     background-color: {$color} !important;
                 }";
    }

    wp_add_inline_style( 'chronocards-ruchir-style', $css );
}
add_action( 'wp_enqueue_scripts', 'chronocards_ruchir_category_colors_css' );

/**
 * Add custom CSS for mobile menu
 */
function chronocards_ruchir_mobile_menu_css() {
    $css = '
        @media (max-width: 768px) {
            .main-navigation ul {
                display: none;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: #34495e;
                flex-direction: column;
                padding: 1rem 0;
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            
            .main-navigation.toggled ul {
                display: flex;
            }
            
            .main-navigation li {
                margin: 0;
                width: 100%;
            }
            
            .main-navigation a {
                display: block;
                padding: 1rem 2rem;
                border-radius: 0;
            }
            
            .menu-toggle {
                display: block;
                background: none;
                border: none;
                color: #ecf0f1;
                font-size: 1.5rem;
                cursor: pointer;
                padding: 0.5rem;
            }
            
            .menu-icon {
                display: flex;
                flex-direction: column;
                width: 25px;
                height: 20px;
            }
            
            .menu-icon span {
                background: #ecf0f1;
                height: 3px;
                margin: 2px 0;
                transition: 0.3s;
            }
            
            .menu-toggle.toggled .menu-icon span:nth-child(1) {
                transform: rotate(-45deg) translate(-5px, 6px);
            }
            
            .menu-toggle.toggled .menu-icon span:nth-child(2) {
                opacity: 0;
            }
            
            .menu-toggle.toggled .menu-icon span:nth-child(3) {
                transform: rotate(45deg) translate(-5px, -6px);
            }
        }
        
        @media (min-width: 769px) {
            .menu-toggle {
                display: none;
            }
        }
    ';
    
    wp_add_inline_style( 'chronocards-ruchir-style', $css );
}
add_action( 'wp_enqueue_scripts', 'chronocards_ruchir_mobile_menu_css' );

/**
 * Add custom CSS for timeline animations
 */
function chronocards_ruchir_timeline_animations_css() {
    $css = '
        .timeline-card {
            opacity: 0;
            transform: translateY(30px);
            transition: opacity 0.6s ease, transform 0.6s ease;
        }
        
        .timeline-card.animate-in {
            opacity: 1;
            transform: translateY(0);
        }
        
        .timeline-card.hovered .timeline-dot {
            transform: translateY(-50%) scale(1.3);
            box-shadow: 0 0 25px rgba(52, 152, 219, 0.6);
        }
        
        .timeline-card.expanded {
            transform: scale(1.02);
            z-index: 10;
        }
        
        .timeline-card.expanded .timeline-dot {
            transform: translateY(-50%) scale(1.5);
            box-shadow: 0 0 30px rgba(52, 152, 219, 0.8);
        }
    ';
    
    wp_add_inline_style( 'chronocards-ruchir-style', $css );
}
add_action( 'wp_enqueue_scripts', 'chronocards_ruchir_timeline_animations_css' );
