<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package ChronoCards_Ruchir
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'chronocards-ruchir' ); ?></a>

<div id="page" class="site">

	<header id="masthead" class="site-header">
		<div class="container">
			<div class="site-branding">
				<?php
				if ( is_front_page() && is_home() ) :
					?>
					<h1 class="site-title">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
							<?php bloginfo( 'name' ); ?>
						</a>
					</h1>
					<?php
				else :
					?>
					<p class="site-title">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
							<?php bloginfo( 'name' ); ?>
						</a>
					</p>
					<?php
				endif;
				$chronocards_ruchir_description = get_bloginfo( 'description', 'display' );
				if ( $chronocards_ruchir_description || is_customize_preview() ) :
					?>
					<p class="site-description"><?php echo esc_html( $chronocards_ruchir_description ); ?></p>
					<?php
				endif;
				?>
			</div><!-- .site-branding -->

			<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'chronocards-ruchir' ); ?>">
				<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
					<span class="screen-reader-text"><?php esc_html_e( 'Primary Menu', 'chronocards-ruchir' ); ?></span>
					<span class="menu-icon">
						<span></span>
						<span></span>
						<span></span>
					</span>
				</button>
				<button class="menu-close" aria-label="<?php esc_attr_e( 'Close Menu', 'chronocards-ruchir' ); ?>">
					<span class="screen-reader-text"><?php esc_html_e( 'Close Menu', 'chronocards-ruchir' ); ?></span>
					<span class="close-icon">×</span>
				</button>
				<?php
				wp_nav_menu(
					array(
						'theme_location' => 'primary',
						'menu_id'        => 'primary-menu',
						'menu_class'     => 'nav-menu',
						'container'      => false,
						'walker'         => new ChronoCards_Walker_Nav_Menu(),
					)
				);
				?>
			</nav><!-- #site-navigation -->
		</div><!-- .container -->
	</header><!-- #masthead -->

	<div id="content" class="site-content">
