<?php
/**
 * The template for displaying archive pages
 *
 * @package ChronoCards_Ruchir
 */

get_header(); ?>

<main id="primary" class="site-main">
	<div class="container">
		<?php if ( have_posts() ) : ?>
			
			<header class="page-header">
				<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				the_archive_description( '<div class="archive-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			<div class="timeline-container">
				<div class="timeline-line"></div>
				
				<?php
				while ( have_posts() ) :
					the_post();

					// Get post category for dynamic styling.
					$categories     = get_the_category();
					$category_class = '';
					if ( ! empty( $categories ) ) {
						$category_class = 'category-' . sanitize_html_class( $categories[0]->slug );
					}

					// Get featured image.
					$featured_image = '';
					if ( has_post_thumbnail() ) {
						$featured_image = get_the_post_thumbnail(
							get_the_ID(),
							'medium_large',
							array(
								'class' => 'card-image',
								'alt'   => get_the_title(),
							)
						);
					}
					?>
				
				<article id="post-<?php the_ID(); ?>" <?php post_class( 'timeline-card ' . $category_class ); ?>>
					<div class="timeline-dot"></div>
					
					<div class="card-content">
						<?php if ( $featured_image ) : ?>
							<a href="<?php the_permalink(); ?>" rel="bookmark">
								<?php echo wp_kses_post( $featured_image ); ?>
							</a>
						<?php endif; ?>
						
						<header class="entry-header">
							<h2 class="card-title">
								<a href="<?php the_permalink(); ?>" rel="bookmark">
									<?php the_title(); ?>
								</a>
							</h2>
						</header>
						
						<div class="entry-summary card-excerpt">
							<?php the_excerpt(); ?>
						</div>
						
						<footer class="entry-meta card-meta">
							<span class="card-date">
								<time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
									<?php echo esc_html( get_the_date() ); ?>
								</time>
							</span>
							
							<?php if ( ! empty( $categories ) ) : ?>
								<span class="card-category">
									<?php echo esc_html( $categories[0]->name ); ?>
								</span>
							<?php endif; ?>
						</footer>
					</div>
				</article>
				
				<?php endwhile; ?>
				
			</div>
			
			<?php
			// Pagination.
			the_posts_pagination(
				array(
					'mid_size'  => 2,
					'prev_text' => __( 'Previous', 'chronocards-ruchir' ),
					'next_text' => __( 'Next', 'chronocards-ruchir' ),
				)
			);
			?>
			
		<?php else : ?>
			
			<section class="no-results not-found">
				<header class="page-header">
					<h1 class="page-title"><?php esc_html_e( 'Nothing here', 'chronocards-ruchir' ); ?></h1>
				</header>
				
				<div class="page-content">
					<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'chronocards-ruchir' ); ?></p>
					<?php get_search_form(); ?>
				</div>
			</section>
			
		<?php endif; ?>
	</div>
</main>

<?php
get_footer();
