<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package ChronoCards_Ruchir
 */

get_header(); ?>

<main id="primary" class="site-main">
	<div class="container">
		<section class="error-404 not-found">
			<header class="page-header">
				<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'chronocards-ruchir' ); ?></h1>
			</header><!-- .page-header -->

			<div class="page-content">
				<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'chronocards-ruchir' ); ?></p>

				<?php get_search_form(); ?>

				<div class="widget">
					<h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'chronocards-ruchir' ); ?></h2>
					<ul>
						<?php
						wp_list_categories(
							array(
								'orderby'    => 'count',
								'order'      => 'DESC',
								'show_count' => 1,
								'title_li'   => '',
								'number'     => 10,
							)
						);
						?>
					</ul>
				</div><!-- .widget -->

				<div class="widget">
					<h2 class="widget-title"><?php esc_html_e( 'Archives', 'chronocards-ruchir' ); ?></h2>
					<ul>
						<?php
						wp_get_archives(
							array(
								'type'  => 'monthly',
								'limit' => 12,
							)
						);
						?>
					</ul>
				</div><!-- .widget -->

				<div class="widget">
					<h2 class="widget-title"><?php esc_html_e( 'Tag Cloud', 'chronocards-ruchir' ); ?></h2>
					<?php
					wp_tag_cloud(
						array(
							'smallest' => 1,
							'largest'  => 1,
							'unit'     => 'rem',
							'number'   => 45,
						)
					);
					?>
				</div><!-- .widget -->

			</div><!-- .page-content -->
		</section><!-- .error-404 -->
	</div>
</main><!-- #primary -->

<?php
get_footer();
