<?php

if ( ! function_exists( 'camera_store_add_similar_section' ) ) :

    function camera_store_add_similar_section() {

        if ( get_theme_mod( 'similar_section_enable' ) == false ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_similar_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        if ( !class_exists('WooCommerce') ) {
            return;
        }

        camera_store_render_similar_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_similar_section_details' ) ) :

    function camera_store_get_similar_section_details( $input ) {
               
        $content = array();
       $page_ids = array();

                for ( $i = 1; $i <= 3; $i++ ) {
                    if ( ! empty( get_theme_mod( 'similar_content_product_' . $i ) ) )
                        $page_ids[] = get_theme_mod( 'similar_content_product_' . $i );
                }

                 $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( 3 ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );  

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = stortech_trim_content( 20 );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';


                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
    
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

add_filter( 'camera_store_filter_similar_section_details', 'camera_store_get_similar_section_details' );

if ( ! function_exists( 'camera_store_render_similar_section' ) ) :

   function camera_store_render_similar_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_similar_section">
        
        <div id="similar-product" class="page-section no-padding-top">
            <div class="wrapper">
                <?php if( !empty( get_theme_mod( 'similar_title' ) ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( get_theme_mod( 'similar_title' ) ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>

                <div class="section-content">

                    <ul class="products col-3">

                        <?php foreach ($content_details as $content ): ?>

                            <li class="product has-post-thumbnail">
                                <div class="post-thumbnail">
                                    <?php 
                                    $product = new WC_Product( $content['id'] );
                                    if ( $product->get_sale_price() ): 
                                        ?>
                                    <span class="onsale">
                                        <?php esc_html_e('Sale!', 'camera-store'); ?>
                                    </span>
                                <?php endif ?>
                                <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>">
                                </a>
                            </div><!-- .post-thumbnail -->

                            <div class="entry-container">
                                <div class="product-meta">
                                    <?php 
                                    $terms = get_the_terms ( $content['id'], 'product_cat' );
                                    foreach ( $terms as $term ) { ?>
                                    <div class="cat-links">
                                        <a href="<?php echo esc_url( get_term_link( $term->term_id, 'product_cat' ) ) ?>"><?php echo esc_html( $term->name) ; ?></a>
                                    </div><!-- .posted_in -->

                                    <?php } ?>
                                </div><!-- .product-meta -->

                                <a href="<?php echo esc_url( $content['url'] ) ; ?>"><h2 class="woocommerce-loop-product__title"><?php echo esc_html( $content['title'] ) ?></h2></a>
                                <span class="price">
                                    <?php 
                                    $product = new WC_Product( $content['id'] );
                                    echo $product->get_price_html();
                                    ?>
                                </span>

                            </div><!-- .entry-container -->
                        </li>

                    <?php endforeach; ?>

                </ul><!-- .product-slider -->

                <?php if( !empty( get_theme_mod( 'similar_btn_url' ) ) && !empty( get_theme_mod( 'similar_btn_label' ) ) ): ?>

                    <div class="read-more">
                        <a href="<?php echo esc_url( get_theme_mod( 'similar_btn_url' ) ); ?>" class="btn btn-fill"><?php echo esc_html( get_theme_mod( 'similar_btn_label' ) ); ?></a>
                    </div><!-- .read-more -->

                <?php endif; ?>

            </div><!-- .section-content -->
        </div><!-- .wrapper -->
    </div><!-- #similar -->

    </div>
     
    <?php }
endif;