<?php

if ( ! function_exists( 'camera_store_add_services_section' ) ) :

    function camera_store_add_services_section() {
    	
        $services_enable = apply_filters( 'stortech_section_status', true, 'services_section_enable' );

        if ( true !== $services_enable ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_services_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        camera_store_render_services_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_services_section_details' ) ) :

    function camera_store_get_services_section_details( $input ) {
           	$options = stortech_get_theme_options();
        	$content = array();
        	$page_ids = array();

                for ( $i = 1; $i <= 6; $i++ ) {
                    if ( ! empty( $options['services_content_page_' . $i] ) )
                        $page_ids[] = $options['services_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( 6 ),
                    'orderby'           => 'post__in',
                    ); 

            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = stortech_trim_content( 15 );

                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

add_filter( 'camera_store_filter_services_section_details', 'camera_store_get_services_section_details' );


if ( ! function_exists( 'camera_store_render_services_section' ) ) :

   function camera_store_render_services_section( $content_details = array() ) {
   		$options = stortech_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_services_section">
        
        <div id="services" class="relative page-section no-padding-top">
        	<div class="wrapper">
        		<div class="section-header">
        			<?php if( !empty( get_theme_mod( 'product_service_title' ) ) ): ?>
        				<h2 class="section-title"><?php echo esc_html( get_theme_mod( 'product_service_title' ) ); ?></h2>
        			<?php endif;

        			if( !empty( get_theme_mod( 'product_service_subtitle' ) ) ): ?>
        			<p class="subtitle"><?php echo esc_html( get_theme_mod( 'product_service_subtitle' ) ); ?></p>
        		<?php endif; ?>
        	</div>

        	<?php if( !empty( get_theme_mod( 'product_service_image' ) ) ): ?>
        		<div class="featured-image">
        			<img src="<?php echo esc_url( get_theme_mod( 'product_service_image' ) ); ?>">
        		</div>
        	<?php endif; ?>

        	<div class=" section-content col-4 clear">

        		<?php $i =1; foreach ($content_details as $content ):
        		$icon    = isset($options['services_content_icon_'.$i]) ? $options['services_content_icon_'.$i] : '';
        		?>

        		<article>
        			<div class="service-item-wrapper">

        				<?php if ( $icon !== '' ): ?>

        					<div class="service-icon">
        						<a href="<?php echo esc_url( $content['url'] ); ?>">
        							<i class="fa <?php echo esc_attr( $icon ) ; ?>"></i>
        						</a>
        					</div>

        				<?php endif; ?>

        				<div class="entry-container">
        					<header class="entry-header">
        						<h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
        					</header>

        					<div class="entry-content">
        						<p><?php echo esc_html( $content['excerpt'] ); ?></p>
        					</div>
        				</div>
        			</div>
        		</article>

        		<?php $i++; endforeach; ?>

        	</div>
        </div>
    </div>

    </div>
        
    <?php }
endif;