<?php
/**
 * Introduction section
 *
 * This is the template for the content of introduction section
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */
if ( ! function_exists( 'camera_store_add_introduction_section' ) ) :
    /**
    * Add introduction section
    *
    *@since Camera Store 1.0.0
    */
    function camera_store_add_introduction_section() {
       
       // Check if client is enabled on frontpage
         if ( get_theme_mod( 'introduction_section_enable' ) == false ) {
            return false;
        }

        // Get introduction section details
        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_introduction_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        if ( !class_exists('WooCommerce') ) {
            return;
        }

        // Render introduction section now.
        camera_store_render_introduction_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_introduction_section_details' ) ) :
    /**
    * introduction section details.
    *
    * @since Camera Store 1.0.0
    * @param array $input introduction section details.
    */
    function camera_store_get_introduction_section_details( $input ) {
              
        $content = array();
        $product_ids = ! empty( get_theme_mod( 'introduction_product_content_product' ) ) ? get_theme_mod( 'introduction_product_content_product' ) : '';
                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => (array)$product_ids,
                    'posts_per_page'    => 1,
                    'orderby'           => 'post__in',
                    );

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = stortech_trim_content( 40 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// introduction section content details.
add_filter( 'camera_store_filter_introduction_section_details', 'camera_store_get_introduction_section_details' );


if ( ! function_exists( 'camera_store_render_introduction_section' ) ) :
  /**
   * Start introduction section
   *
   * @return string introduction content
   * @since Camera Store 1.0.0
   *
   */
   function camera_store_render_introduction_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_introduction_section">
        
        <div id="introduction" class="page-section">
                <div class="wrapper">

                <?php foreach ($content_details as $content ): ?>

                    <article>
                        <div class="entry-container">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                <?php if( !empty( get_theme_mod( 'introduction_subtitle' ) ) ){ ?>
                                <span class="sub-title"><?php echo esc_html( get_theme_mod( 'introduction_subtitle' ) ); ?></span>
                                <?php } ?>
                            </header>

                            <div class="featured-image">
                                <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="camera"></a>
                            </div>

                            <div class="entry-content">
                                <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                <span class="product-text">
                                    <?php 
                                    if(!empty( get_theme_mod( 'introduction_product_text' ) ) ){
                                        echo esc_html( get_theme_mod( 'introduction_product_text' ) );
                                    }
                                    $product = new WC_Product( $content['id'] );
                                    echo $product->get_price_html();
                                    ?>
                                 </span>
                            </div><!-- .entry-content-->
                        </div><!-- .entry-container -->
                    </article>
                    
                <?php endforeach; ?>
                    
                </div><!-- .wrapper -->
            </div><!-- #featured-slider -->

            </div>
                
<?php    }
endif;