<?php
/**
 * Introduction section
 *
 * This is the template for the content of cta section
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */
if ( ! function_exists( 'camera_store_add_cta_section' ) ) :
    /**
    * Add cta section
    *
    *@since Camera Store 1.0.0
    */
    function camera_store_add_cta_section() {
        
        // Check if client is enabled on frontpage
        if ( get_theme_mod( 'cta_section_enable' ) == false ) {
            return false;
        }
        // Get cta section details
        $section_details = array();
        $section_details = apply_filters( 'camera_store_filter_cta_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render cta section now.
        camera_store_render_cta_section( $section_details );
    }
endif;

if ( ! function_exists( 'camera_store_get_cta_section_details' ) ) :
    /**
    * cta section details.
    *
    * @since Camera Store 1.0.0
    * @param array $input cta section details.
    */
    function camera_store_get_cta_section_details( $input ) {
               
        $content = array();
        $page_id = ! empty( get_theme_mod( 'cta_content_page' ) ) ? get_theme_mod( 'cta_content_page' ) : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    ); 

            // Run The Loop.
            $query = new WP_Query( $args );

            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = stortech_trim_content( 50 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// cta section content details.
add_filter( 'camera_store_filter_cta_section_details', 'camera_store_get_cta_section_details' );


if ( ! function_exists( 'camera_store_render_cta_section' ) ) :
  /**
   * Start cta section
   *
   * @return string cta content
   * @since Camera Store 1.0.0
   *
   */
   function camera_store_render_cta_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="stortech_cta_section">

        <?php foreach ($content_details as $content ): ?>
            
             <div id="cta" style="background-image:url(<?php echo esc_url( $content['image'] ); ?>)">
                <div class="overlay"></div>
                <div class="wrapper">
                    <div class="cta-wrapper">
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                        </div>

                        <div class="section-content">
                            <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                        </div><!-- .section-content -->
                    </div><!-- .cta-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- #cta -->

        <?php endforeach; ?>
        </div>

        <?php
    }
endif;