<?php
/**
 * similar Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */
if ( !class_exists('WooCommerce') ) {
	return;
}

// Add similar section
$wp_customize->add_section( 'stortech_similar_section', array(
	'title'             => esc_html__( 'Similar Product Section','camera-store' ),
	'description'       => esc_html__( 'Similar Product Section Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 53,
) );

// similar content enable control and setting
$wp_customize->add_setting( 'similar_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'similar_section_enable', array(
	'label'             => esc_html__( 'Similar product Section Enable', 'camera-store' ),
	'section'           => 'stortech_similar_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// similar title setting and control
$wp_customize->add_setting( 'similar_title', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __('Popular Products', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'similar_title', array(
	'label'           	=> esc_html__( 'Title', 'camera-store' ),
	'section'        	=> 'stortech_similar_section',
	'active_callback' 	=> 'camera_store_is_similar_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'similar_title', array(
		'selector'            => '#product_layout_similar-products .section-header h2',
		'settings'            => 'similar_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'stortech_similar_title_partial',
    ) );
}

for( $i = 1 ; $i <= 3; $i++ ){

	$wp_customize->add_setting( 'similar_content_product_' . $i, array(
		'sanitize_callback' => 'stortech_sanitize_page',
	) );

	$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'similar_content_product_' . $i, array(
		'label'             => sprintf( esc_html__( 'Select Product %d', 'camera-store' ), $i ),
		'section'           => 'stortech_similar_section',
		'choices'			=> stortech_product_choices(),
		'active_callback'	=> 'camera_store_is_similar_section_enable',
	) ) );
}

$wp_customize->add_setting( 'similar_btn_label', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default' 			=> __('View All', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'similar_btn_label', array(
	'label'           	=>  esc_html__( 'Button Lable', 'camera-store' ),
	'section'        	=> 'stortech_similar_section',
	'active_callback' 	=> 'camera_store_is_similar_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'similar_btn_label', array(
		'selector'            => '#product_layout_similar-products .section-header h2',
		'settings'            => 'similar_btn_label',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'stortech_similar_btn_label_partial',
    ) );
}

$wp_customize->add_setting( 'similar_btn_url', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'similar_btn_url', array(
	'label'           	=>  esc_html__( 'Button Link ', 'camera-store' ),
	'section'        	=> 'stortech_similar_section',
	'active_callback' 	=> 'camera_store_is_similar_section_enable',
	'type'				=> 'url',
) );