<?php

// recent_product title setting and control
$wp_customize->add_setting( 'product_service_title', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __( 'Characteristics of Camera', 'camera-store' ),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'product_service_title', array(
	'label'           	=> esc_html__( 'Title', 'camera-store' ),
	'section'        	=> 'stortech_services_section',
	'active_callback' 	=> 'stortech_is_services_section_enable',
	'type'				=> 'text',
	'priority' 			=> 11,
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'product_service_title', array(
		'selector'            => '#services h2.section-title',
		'settings'            => 'product_service_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_product_service_title_partial',
    ) );
}

// recent_product title setting and control
$wp_customize->add_setting( 'product_service_subtitle', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __( 'Best & affordable cameras, light weight,outstanding image quality, large image sensor.', 'camera-store' ),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'product_service_subtitle', array(
	'label'           	=> esc_html__( 'Sub Title', 'camera-store' ),
	'section'        	=> 'stortech_services_section',
	'active_callback' 	=> 'stortech_is_services_section_enable',
	'type'				=> 'text',
	'priority' 			=> 12,
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'product_service_subtitle', array(
		'selector'            => '#services p.subtitle',
		'settings'            => 'product_service_subtitle',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_product_service_subtitle_partial',
    ) );
}

// service image setting and control.
$wp_customize->add_setting( 'product_service_image', array(
	'sanitize_callback' => 'stortech_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'product_service_image',
		array(
		'label'       		=> esc_html__( 'Image', 'camera-store' ),
		'section'     		=> 'stortech_services_section',
		'active_callback'	=> 'stortech_is_services_section_enable',
		'priority' 			=> 13,
) ) );