<?php
/**
 * Gallery Section options
 *
 * @package Theme Palace
 * @subpackage Gallery
 * @since Gallery 1.0.0
 */

// Add Gallery section
$wp_customize->add_section( 'stortech_gallery_section', array(
	'title'             => esc_html__( 'Gallery','camera-store' ),
	'description'       => esc_html__( 'Gallery Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 14,
) );

// Gallery content enable control and setting
$wp_customize->add_setting( 'gallery_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'gallery_section_enable', array(
	'label'             => esc_html__( 'Gallery Section Enable', 'camera-store' ),
	'section'           => 'stortech_gallery_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// recent_product title setting and control
$wp_customize->add_setting( 'gallery_title', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __( 'Build for better quality image', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'gallery_title', array(
	'label'           	=> esc_html__( 'Title', 'camera-store' ),
	'section'        	=> 'stortech_gallery_section',
	'active_callback' 	=> 'stortech_is_gallery_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'gallery_title', array(
		'selector'            => '#camera-masonry h2.section-title',
		'settings'            => 'gallery_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_gallery_title_partial',
    ) );
}

// recent_product title setting and control
$wp_customize->add_setting( 'gallery_subtitle', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __( 'Best & affordable cameras, light weight, outstanding image quality,large image sensor.', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'gallery_subtitle', array(
	'label'           	=> esc_html__( 'Sub Title', 'camera-store' ),
	'section'        	=> 'stortech_gallery_section',
	'active_callback' 	=> 'stortech_is_gallery_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'gallery_subtitle', array(
		'selector'            => '#camera-masonry .section-content p',
		'settings'            => 'gallery_subtitle',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_gallery_subtitle_partial',
    ) );
}

for ( $i = 1; $i <= 5; $i++ ) :
	
	// gallery posts drop down chooser control and setting
	$wp_customize->add_setting( 'gallery_content_post_'.$i, array(
		'sanitize_callback' => 'stortech_sanitize_page',
	) );

	$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'gallery_content_post_'.$i, array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'camera-store' ), $i ),
		'section'           => 'stortech_gallery_section',
		'choices'			=> stortech_post_choices(),
		'active_callback'	=> 'stortech_is_gallery_section_enable',
	) ) ); 

endfor;