<?php
/**
 * About Us Section options
 *
 * @package Theme Palace
 * @subpackage Camera Store
 * @since Camera Store 1.0.0
 */

// Add About Us section
$wp_customize->add_section( 'stortech_about_section', array(
	'title'             => esc_html__( 'About Us','camera-store' ),
	'description'       => esc_html__( 'About Us Section options.', 'camera-store' ),
	'panel'             => 'stortech_front_page_panel',
	'priority' 			=> 12,
) );

// About Us content enable control and setting
$wp_customize->add_setting( 'about_section_enable', array(
	'sanitize_callback' => 'stortech_sanitize_switch_control',
	'default' => false,
) );

$wp_customize->add_control( new Camera_Store_Switch_Control( $wp_customize, 'about_section_enable', array(
	'label'             => esc_html__( 'About Us Section Enable', 'camera-store' ),
	'section'           => 'stortech_about_section',
	'on_off_label' 		=> stortech_switch_options(),
) ) );

// about pages drop down chooser control and setting
$wp_customize->add_setting( 'about_content_page', array(
	'sanitize_callback' => 'stortech_sanitize_page',
) );

$wp_customize->add_control( new Camera_Store_Dropdown_Chooser( $wp_customize, 'about_content_page', array(
	'label'             => esc_html__( 'Select Page', 'camera-store' ), 
	'section'           => 'stortech_about_section',
	'choices'			=> stortech_page_choices(),
	'active_callback'	=> 'camera_store_is_about_section_enable',
) ) );

$wp_customize->add_setting( 'about_btn_label', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> __('Explore More', 'camera-store'),
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'about_btn_label', array(
	'label'           	=>  esc_html__( 'Button Label', 'camera-store' ),
	'section'        	=> 'stortech_about_section',
	'active_callback' 	=> 'camera_store_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'about_btn_label', array(
		'selector'            => '#gallery .read-more a',
		'settings'            => 'about_btn_label',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'camera_store_about_btn_label_partial',
    ) );
}