<?php

if ( ! function_exists( 'camera_store_enqueue_styles' ) ) :

	function camera_store_enqueue_styles() {
		wp_enqueue_style( 'camera-store-style-parent', get_template_directory_uri() . '/style.css' );

		wp_enqueue_style( 'camera-store-style', get_stylesheet_directory_uri() . '/style.css', array( 'camera-store-style-parent' ), '1.0.0' );

		wp_enqueue_script( 'camera-store-custom', get_theme_file_uri() . '/custom.js', array(), '1.0', true );

		wp_enqueue_style( 'camera-store-fonts', camera_store_fonts_url(), array(), null );
	}

endif;

add_action( 'wp_enqueue_scripts', 'camera_store_enqueue_styles', 99 );

function camera_store_customize_control_style() {


	wp_enqueue_style( 'camera-store-customize-controls', get_theme_file_uri() . '/customizer-control.css' );

}
add_action( 'customize_controls_enqueue_scripts', 'camera_store_customize_control_style' );

if ( !function_exists( 'camera_store_block_editor_styles' ) ):

	function camera_store_block_editor_styles() {
		wp_enqueue_style( 'camera-store-fonts', camera_store_fonts_url(), array(), null );
	}

endif;

add_action( 'enqueue_block_editor_assets', 'camera_store_block_editor_styles' );


if ( ! function_exists( 'camera_store_fonts_url' ) ) :

function camera_store_fonts_url() {
	
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	if ( 'off' !== _x( 'on', 'Barlow font: on or off', 'camera-store' ) ) {
		$fonts[] = 'Barlow:400,500,700';
	}

	if ( 'off' !== _x( 'on', 'Josefin Sans font: on or off', 'camera-store' ) ) {
		$fonts[] = 'Josefin Sans:400,600';
	}

	if ( 'off' !== _x( 'on', 'Lora font: on or off', 'camera-store' ) ) {
		$fonts[] = 'Lora:400,700';
	}

	if ( 'off' !== _x( 'on', 'Lato font: on or off', 'camera-store' ) ) {
		$fonts[] = 'Lato:400,500';
	}

	if ( 'off' !== _x( 'on', 'Playfair Display font: on or off', 'camera-store' ) ) {
		$fonts[] = 'Playfair Display:400,500';
	}

	$query_args = array(
		'family' => urlencode( implode( '|', $fonts ) ),
		'subset' => urlencode( $subsets ),
	);

	if ( $fonts ) {
		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}

endif;

if ( ! function_exists( 'camera_store_body_classes' ) ) :

	function camera_store_body_classes( $classes ) {

		$body_class[] = 'product woocommerce woocommerce-page child';

		return $body_class;

	}

endif;

add_filter( 'body_class', 'camera_store_body_classes' );

require get_theme_file_path() . '/inc/customizer.php';

require get_theme_file_path() . '/inc/front-sections/introduction.php';

require get_theme_file_path() . '/inc/front-sections/about.php';

require get_theme_file_path() . '/inc/front-sections/cta.php';

require get_theme_file_path() . '/inc/front-sections/gallery.php';

require get_theme_file_path() . '/inc/front-sections/service.php';

require get_theme_file_path() . '/inc/front-sections/design.php';

require get_theme_file_path() . '/inc/front-sections/zoom.php';

require get_theme_file_path() . '/inc/front-sections/similar.php';