<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'businessdot_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function businessdot_enqueue_styles() {
        wp_enqueue_style( 'businesstar-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'businessdot-style', get_stylesheet_directory_uri() . '/style.css', array( 'businesstar-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'businessdot_enqueue_styles', 99 );

// END ENQUEUE PARENT ACTION
if ( ! function_exists( 'businessdot_fonts_url' ) ) :

	function businessdot_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lobster, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Lobster font: on or off', 'businessdot' ) ) {
		$fonts[] = 'Lobster:300,400,500,600,700';
	}

	/* translators: If there are characters in your language that are not supported by Teko, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Teko: on or off', 'businessdot' ) ) {
		$fonts[] = 'Teko:300,400,500,600,700';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}
endif;
