<?php

if ( ! get_theme_mod( 'businesity_enable_goal_section', false ) ) {
	return;
}

$content_id = $section_content = array();

$content_type = get_theme_mod( 'businesity_goal_content_type', 'page' );
if ( in_array( $content_type, array( 'post', 'page' ) ) ) {

	if ( 'post' === $content_type ) {
		$content_id[] = get_theme_mod( 'businesity_goal_content_post' );
	} else {
		$content_id[] = get_theme_mod( 'businesity_goal_content_page' );
	}
	$args = array(
		'post_type'           => $content_type,
		'post__in'            => $content_id,
		'orderby'             => 'post__in',
		'posts_per_page'      => 1,
		'ignore_sticky_posts' => true,
	);

	$query = new WP_Query( $args );
	if ( $query->have_posts() ) :
		while ( $query->have_posts() ) :
			$query->the_post();
			$section_content['title']     = get_the_title();
			$section_content['excerpt']   = get_the_excerpt();
			$section_content['permalink'] = get_the_permalink();
		endwhile;
		wp_reset_postdata();

		$section_content = apply_filters( 'businesity_goal_section_content', $section_content );

		businesity_render_goal_section( $section_content );
	endif;
}

function businesity_render_goal_section( $section_content ) {
	$additional_box    = get_theme_mod( 'businesity_enable_goal_box', false );
	$excerpt_more_text = get_theme_mod( 'charityup_excerpt_more_text', __( 'Read More', 'businesity' ) );
	$goal_button_label = get_theme_mod( 'businesity_goal_button_label', __( 'Read More', 'businesity' ) );
	$goal_button_label = ! empty( $goal_button_label ) ? $goal_button_label : $excerpt_more_text;
	?>
	<section id="businesity_goal_section" class=" mission-vision-section ptb">
		<?php
		if ( is_customize_preview() ) :
			charityup_section_link( 'businesity_goal_section' );
		endif;
		?>
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12 col-lg-6">
					<div class="inner">
						<div class="section-title">
							<h2 class="mb-35"><?php echo esc_html( $section_content['title'] ); ?></h2>
						</div>
						<?php echo esc_html( $section_content['excerpt'] ); ?>
						<?php if ( ! empty( $goal_button_label ) ) { ?>
							<div class="custom-btn mt-65">
								<a href="<?php echo esc_url( $section_content['permalink'] ); ?>" class="btn primary-btn"><?php echo esc_html( $goal_button_label ); ?></a>
							</div>
						<?php } ?>
					</div>
				</div>
				<?php if ( $additional_box ) { ?>
					<div class="col-md-12 col-lg-6">
						<div class="row">
							<div class="col-md-6 mission-column-wrap">
								<div class="mission-single mb-30">
									<?php
									$box_icon        = get_theme_mod( 'businesity_goal_box_icon_1' );
									$box_label       = get_theme_mod( 'businesity_goal_box_label_1' );
									$box_link        = get_theme_mod( 'businesity_goal_box_link_1' );
									$box_link        = ! empty( $box_link ) ? $box_link : '#';
									$read_more_label = get_theme_mod( 'chairtyup_excerpt_more_text', __( 'Read More', 'businesity' ) );
									?>
									<?php if ( ! empty( $box_icon ) ) { ?>
										<div class="mission-img">
											<img src="<?php echo esc_url( $box_icon ); ?>" alt="<?php echo esc_attr( $box_label ); ?>">
										</div>
									<?php } ?>
									<div class="mission-content">
										<h4 class="mission-title"><?php echo esc_html( $box_label ); ?></h4>
										<?php if ( ! empty( $box_link ) ) { ?>
											<div class="read-more mt-20">
												<a href="<?php echo esc_url( $box_link ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
											</div>
										<?php } ?>
									</div>
								</div>
								<div class="mission-single mb-30">
									<?php
									$box_icon        = get_theme_mod( 'businesity_goal_box_icon_2' );
									$box_label       = get_theme_mod( 'businesity_goal_box_label_2' );
									$box_link        = get_theme_mod( 'businesity_goal_box_link_2' );
									$box_link        = ! empty( $box_link ) ? $box_link : '#';
									$read_more_label = get_theme_mod( 'charityup_excerpt_more_text', __( 'Read More', 'businesity' ) );
									?>
									<?php if ( ! empty( $box_icon ) ) { ?>
										<div class="mission-img">
											<img src="<?php echo esc_url( $box_icon ); ?>" alt="<?php echo esc_attr( $box_label ); ?>">
										</div>
									<?php } ?>
									<div class="mission-content">
										<h4 class="mission-title"><?php echo esc_html( $box_label ); ?></h4>
										<?php if ( ! empty( $box_link ) ) { ?>
											<div class="read-more mt-20">
												<a href="<?php echo esc_url( $box_link ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="col-md-6 mission-column-wrap">
								<div class="mission-single mb-30">
									<?php
									$box_icon        = get_theme_mod( 'businesity_goal_box_icon_3' );
									$box_label       = get_theme_mod( 'businesity_goal_box_label_3' );
									$box_link        = get_theme_mod( 'businesity_goal_box_link_3' );
									$box_link        = ! empty( $box_link ) ? $box_link : '#';
									$read_more_label = get_theme_mod( 'charityup_excerpt_more_text', __( 'Read More', 'businesity' ) );
									?>
									<?php if ( ! empty( $box_icon ) ) { ?>
										<div class="mission-img">
											<img src="<?php echo esc_url( $box_icon ); ?>" alt="<?php echo esc_attr( $box_label ); ?>">
										</div>
									<?php } ?>
									<div class="mission-content">
										<h4 class="mission-title"><?php echo esc_html( $box_label ); ?></h4>
										<?php if ( ! empty( $box_link ) ) { ?>
											<div class="read-more mt-20">
												<a href="<?php echo esc_url( $box_link ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
											</div>
										<?php } ?>
									</div>
								</div>
								<div class="mission-single mb-30">
									<?php
									$box_icon        = get_theme_mod( 'businesity_goal_box_icon_4' );
									$box_label       = get_theme_mod( 'businesity_goal_box_label_4' );
									$box_link        = get_theme_mod( 'businesity_goal_box_link_4' );
									$box_link        = ! empty( $box_link ) ? $box_link : '#';
									$read_more_label = get_theme_mod( 'charityup_excerpt_more_text', __( 'Read More', 'businesity' ) );
									?>
									<?php if ( ! empty( $box_icon ) ) { ?>
										<div class="mission-img">
											<img src="<?php echo esc_url( $box_icon ); ?>" alt="<?php echo esc_attr( $box_label ); ?>">
										</div>
									<?php } ?>
									<div class="mission-content">
										<h4 class="mission-title"><?php echo esc_html( $box_label ); ?></h4>
										<?php if ( ! empty( $box_link ) ) { ?>
											<div class="read-more mt-20">
												<a href="<?php echo esc_url( $box_link ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
	<?php
}
