<?php

if ( ! get_theme_mod( 'businesity_enable_features_section', false ) ) {
	return;
}

$content_ids     = array();
$section_content = array();
$content_count   = 4;
$content_type    = get_theme_mod( 'businesity_features_content_type', 'page' );

if ( in_array( $content_type, array( 'post', 'page' ) ) ) {

	for ( $i = 1; $i <= $content_count; $i++ ) {
		$content_ids[] = get_theme_mod( 'businesity_features_content_' . $content_type . '_' . $i );
	}

	$args = array(
		'post_type'           => $content_type,
		'post__in'            => $content_ids,
		'orderby'             => 'post__in',
		'posts_per_page'      => absint( $content_count ),
		'ignore_sticky_posts' => true,
	);

} else {
	$cat_content_id = get_theme_mod( 'businesity_features_content_category' );
	$args           = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( $content_count ),
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	while ( $query->have_posts() ) :
		$query->the_post();
		$data['title']     = get_the_title();
		$data['excerpt']   = get_the_excerpt();
		$data['permalink'] = get_the_permalink();
		array_push( $section_content, $data );
	endwhile;
	wp_reset_postdata();
endif;

$section_content = apply_filters( 'businesity_goal_section_content', $section_content );

businesity_render_features_section( $section_content );

/**
 * Render Features Section.
 */
function businesity_render_features_section( $section_content ) {
	$section_title   = get_theme_mod( 'businesity_features_section_title', 'Our Features' );
	$center_image    = get_theme_mod( 'businesity_features_center_image' );
	$read_more_label = get_theme_mod( 'charityup_excerpt_more_text', __( 'Read More', 'businesity' ) );
	$button_label    = get_theme_mod( 'businesity_features_button_label' );
	$button_link     = get_theme_mod( 'businesity_features_button_link' );
	$button_link     = ! empty( $button_link ) ? $button_link : '#';

	$counter     = 1;
	$first_half  = array();
	$second_half = array();
	$first_half  = array_slice( $section_content, 0, 2 );
	$second_half = array_slice( $section_content, 2, 4 );
	?>
	<section id="businesity_features_section" class="middle-image-section ptb has-custom-btn">
		<?php
		if ( is_customize_preview() ) :
			charityup_section_link( 'businesity_features_section' );
		endif;
		?>
		<div class="container">
			<?php if ( ! empty( $section_title ) ) { ?>
				<div class="section-title mb-60">
					<h2><?php echo esc_html( $section_title ); ?></h2>
				</div>
			<?php } ?>

			<div class="row align-items-center">
				<?php if ( ! empty( $first_half ) ) { ?>
					<div class="col-lg-4 col-md-12 feat-text">
						<div class="text-part">
							<?php foreach ( $first_half as $item ) { ?>
								<div class="text-part-single">
									<div class="defaut-number">
										<span><?php echo esc_html( $counter++ ); ?></span>
									</div>
									<div class="detail-part">
										<h3><?php echo esc_html( $item['title'] ); ?></h3>
										<?php echo esc_html( $item['excerpt'] ); ?>
										<div class="read-more mt-20">
											<a href="<?php echo esc_url( $item['permalink'] ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
										</div>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php } ?>

				<?php if ( ! empty( $center_image ) ) { ?>
					<div class="col-lg-4 col-md-12 feat-img">
						<div class="image-part">
							<img src="<?php echo esc_url( $center_image ); ?>" alt="">
						</div>    
					</div>
				<?php } ?>

				<?php if ( ! empty( $second_half ) ) { ?>
					<div class="col-lg-4 col-md-12 feat-text">
						<div class="text-part">
							<?php foreach ( $second_half as $item ) { ?>
								<div class="text-part-single">
									<div class="defaut-number">
									<span><?php echo esc_html( $counter++ ); ?></span>
									</div>
									<div class="detail-part">
										<h3><?php echo esc_html( $item['title'] ); ?></h3>
										<?php echo esc_html( $item['excerpt'] ); ?>
										<div class="read-more mt-20">
											<a href="<?php echo esc_url( $item['permalink'] ); ?>"><?php echo esc_html( $read_more_label ); ?></a>
										</div>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>

			<?php if ( ! empty( $button_label ) ) { ?>
				<div class="custom-btn">
					<a href="<?php echo esc_url( $button_link ); ?>" class="btn btn-transparent"><?php echo esc_html( $button_label ); ?></a>
				</div>
			<?php } ?>
		</div>
	</section>
	<?php
}
