<?php

if ( ! get_theme_mod( 'businesity_enable_case_study_section', false ) ) {
	return;
}

$content_ids   = array();
$content_count = get_theme_mod( 'businesity_case_study_count', 6 );
$content_type  = get_theme_mod( 'businesity_case_study_content_type', 'page' );

if ( in_array( $content_type, array( 'post', 'page' ) ) ) {

	for ( $i = 1; $i <= $content_count; $i++ ) {
		$content_ids[] = get_theme_mod( 'businesity_case_study_content_' . $content_type . '_' . $i );
	}

	$args = array(
		'post_type'           => $content_type,
		'post__in'            => $content_ids,
		'orderby'             => 'post__in',
		'posts_per_page'      => absint( $content_count ),
		'ignore_sticky_posts' => true,
	);

} else {
	$cat_content_id = get_theme_mod( 'businesity_case_study_content_category' );

	$args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( $content_count ),
	);
}

$args = apply_filters( 'businesity_case_study_section_args', $args );

businesity_render_case_study_section( $args );

/**
 * Render Case Study Section.
 */
function businesity_render_case_study_section( $args ) {
	$section_title   = get_theme_mod( 'businesity_case_study_title', 'Our Services' );
	$cs_button_label = get_theme_mod( 'businesity_case_study_button_label' );
	$cs_button_link  = get_theme_mod( 'businesity_case_study_button_link' );
	$cs_button_link  = ! empty( $cs_button_link ) ? $cs_button_link : '#';

	$query = new WP_Query( $args );
	?>
	<section id="businesity_case_study_section" class="case-studies-section ptb has-custom-btn">
		<?php
		if ( is_customize_preview() ) :
			charityup_section_link( 'businesity_case_study_section' );
		endif;
		?>
		<div class="container">
			<div class="section-title mb-60">
				<h2><?php echo esc_html( $section_title ); ?></h2>
			</div>
			<?php if ( $query->have_posts() ) : ?>
				<div class="case-studies-wrapper">
					<?php
					while ( $query->have_posts() ) :
						$query->the_post();
						?>
						<div class="case-study-single">
							<div class="case-study-img">
								<a href="<?php the_permalink(); ?>">
									<?php the_post_thumbnail(); ?>
								</a>
							</div>
							<div class="case-study-content">
								<h4 class="case-study-title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h4>
								<?php the_excerpt(); ?>
							</div>
						</div>
						<?php
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			<?php endif; ?>

			<?php if ( ! empty( $cs_button_label ) ) { ?>
				<div class="custom-btn">
					<a href="<?php echo esc_url( $cs_button_link ); ?>" class="btn btn-transparent"><?php echo esc_html( $cs_button_label ); ?></a>
				</div>
			<?php } ?>
		</div>
	</section>
	<?php
}
