<?php
/**
 * Goal Section
 *
 * @package Businesity
 */

$wp_customize->add_section(
	'businesity_goal_section',
	array(
		'panel' => 'charityup_front_page_options',
		'title' => esc_html__( 'Goal Section', 'businesity' ),
	)
);

// Goal Section - Enable Section.
$wp_customize->add_setting(
	'businesity_enable_goal_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'charityup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new CharityUp_Toggle_Switch_Custom_Control(
		$wp_customize,
		'businesity_enable_goal_section',
		array(
			'label'    => esc_html__( 'Enable Goal Section', 'businesity' ),
			'section'  => 'businesity_goal_section',
			'settings' => 'businesity_enable_goal_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'businesity_enable_goal_section',
		array(
			'selector' => '#businesity_goal_section .section-link',
			'settings' => 'businesity_enable_goal_section',
		)
	);
}

// Goal Section - Content Type.
$wp_customize->add_setting(
	'businesity_goal_content_type',
	array(
		'default'           => 'page',
		'sanitize_callback' => 'charityup_sanitize_select',
	)
);

$wp_customize->add_control(
	'businesity_goal_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'businesity' ),
		'section'         => 'businesity_goal_section',
		'settings'        => 'businesity_goal_content_type',
		'type'            => 'select',
		'active_callback' => 'businesity_is_goal_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'businesity' ),
			'post' => esc_html__( 'Post', 'businesity' ),
		),
	)
);

// Goal Section - Content Type Post.
$wp_customize->add_setting(
	'businesity_goal_content_post',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'businesity_goal_content_post',
	array(
		'section'         => 'businesity_goal_section',
		'settings'        => 'businesity_goal_content_post',
		'label'           => esc_html__( 'Select Post', 'businesity' ),
		'active_callback' => 'businesity_is_goal_section_and_content_type_post_enabled',
		'type'            => 'select',
		'choices'         => charityup_get_post_choices(),
	)
);

// Goal Section - Content Type Page.
$wp_customize->add_setting(
	'businesity_goal_content_page',
	array(
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'businesity_goal_content_page',
	array(
		'label'           => esc_html__( 'Select Page', 'businesity' ),
		'section'         => 'businesity_goal_section',
		'settings'        => 'businesity_goal_content_page',
		'active_callback' => 'businesity_is_goal_section_and_content_type_page_enabled',
		'type'            => 'select',
		'choices'         => charityup_get_page_choices(),
	)
);

// Goal Section - Button Label.
$wp_customize->add_setting(
	'businesity_goal_button_label',
	array(
		'default'           => __( 'Learn More', 'businesity' ),
		'sanitize_callback' => 'sanitize_text_field',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'businesity_goal_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'businesity' ),
		'section'         => 'businesity_goal_section',
		'settings'        => 'businesity_goal_button_label',
		'type'            => 'text',
		'active_callback' => 'businesity_is_goal_section_enabled',
	)
);

// Goal Section - Additional Boxes.
$wp_customize->add_setting(
	'businesity_enable_goal_box',
	array(
		'default'           => false,
		'sanitize_callback' => 'charityup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new CharityUp_Toggle_Switch_Custom_Control(
		$wp_customize,
		'businesity_enable_goal_box',
		array(
			'label'           => esc_html__( 'Additional Boxes?', 'businesity' ),
			'section'         => 'businesity_goal_section',
			'settings'        => 'businesity_enable_goal_box',
			'active_callback' => 'businesity_is_goal_section_enabled',
		)
	)
);

for ( $i = 1; $i <= 4; $i++ ) {

	// Additional Box - Icon.
	$wp_customize->add_setting(
		'businesity_goal_box_icon_' . $i,
		array(
			'sanitize_callback' => 'charityup_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'businesity_goal_box_icon_' . $i,
			array(
				'label'           => esc_html__( 'Icon ', 'businesity' ) . $i,
				'section'         => 'businesity_goal_section',
				'settings'        => 'businesity_goal_box_icon_' . $i,
				'active_callback' => 'businesity_is_goal_section_and_additional_box_enabled',
			)
		)
	);

	// Additional Box - Label.
	$wp_customize->add_setting(
		'businesity_goal_box_label_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'businesity_goal_box_label_' . $i,
		array(
			'label'           => esc_html__( 'Label ', 'businesity' ) . $i,
			'section'         => 'businesity_goal_section',
			'settings'        => 'businesity_goal_box_label_' . $i,
			'type'            => 'text',
			'active_callback' => 'businesity_is_goal_section_and_additional_box_enabled',
		)
	);

	// Additional Box - Link.
	$wp_customize->add_setting(
		'businesity_goal_box_link_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'businesity_goal_box_link_' . $i,
		array(
			'label'           => esc_html__( 'Link', 'businesity' ),
			'section'         => 'businesity_goal_section',
			'settings'        => 'businesity_goal_box_link_' . $i,
			'type'            => 'url',
			'active_callback' => 'businesity_is_goal_section_and_additional_box_enabled',
		)
	);

}
