<?php
/**
 * Features Section
 *
 * @package Businesity
 */

$wp_customize->add_section(
	'businesity_features_section',
	array(
		'panel' => 'charityup_front_page_options',
		'title' => esc_html__( 'Features Section', 'businesity' ),
	)
);

// Features Section - Enable Section.
$wp_customize->add_setting(
	'businesity_enable_features_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'charityup_sanitize_switch',
	)
);

$wp_customize->add_control(
	new CharityUp_Toggle_Switch_Custom_Control(
		$wp_customize,
		'businesity_enable_features_section',
		array(
			'label'    => esc_html__( 'Enable Features Section', 'businesity' ),
			'section'  => 'businesity_features_section',
			'settings' => 'businesity_enable_features_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'businesity_enable_features_section',
		array(
			'selector' => '#businesity_features_section .section-link',
			'settings' => 'businesity_enable_features_section',
		)
	);
}

// Features Section - Section Title.
$wp_customize->add_setting(
	'businesity_features_section_title',
	array(
		'default'           => __( 'Our Features', 'businesity' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'businesity_features_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'businesity' ),
		'section'         => 'businesity_features_section',
		'settings'        => 'businesity_features_section_title',
		'type'            => 'text',
		'active_callback' => 'businesity_is_features_section_enabled',
	)
);

// Features Section - Center Image.
$wp_customize->add_setting(
	'businesity_features_center_image',
	array(
		'sanitize_callback' => 'charityup_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'businesity_features_center_image',
		array(
			'label'           => esc_html__( 'Center Image', 'businesity' ),
			'section'         => 'businesity_features_section',
			'settings'        => 'businesity_features_center_image',
			'active_callback' => 'businesity_is_features_section_enabled',
		)
	)
);

// Features Section - Content Type.
$wp_customize->add_setting(
	'businesity_features_content_type',
	array(
		'default'           => 'page',
		'sanitize_callback' => 'charityup_sanitize_select',
	)
);

$wp_customize->add_control(
	'businesity_features_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'businesity' ),
		'section'         => 'businesity_features_section',
		'settings'        => 'businesity_features_content_type',
		'type'            => 'select',
		'active_callback' => 'businesity_is_features_section_enabled',
		'choices'         => array(
			'page'     => esc_html__( 'Page', 'businesity' ),
			'post'     => esc_html__( 'Post', 'businesity' ),
			'category' => esc_html__( 'Category', 'businesity' ),
		),
	)
);

// List out selected number of fields.
for ( $i = 1; $i <= 4; $i++ ) {
	// Features Section - Select Post.
	$wp_customize->add_setting(
		'businesity_features_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'businesity_features_content_post_' . $i,
		array(
			'label'           => esc_html__( 'Select Post ', 'businesity' ) . $i,
			'section'         => 'businesity_features_section',
			'settings'        => 'businesity_features_content_post_' . $i,
			'active_callback' => 'businesity_is_features_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => charityup_get_post_choices(),
		)
	);

	// Features Section - Select Page.
	$wp_customize->add_setting(
		'businesity_features_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'businesity_features_content_page_' . $i,
		array(
			'label'           => esc_html__( 'Select Page ', 'businesity' ) . $i,
			'section'         => 'businesity_features_section',
			'settings'        => 'businesity_features_content_page_' . $i,
			'active_callback' => 'businesity_is_features_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => charityup_get_page_choices(),
		)
	);

}

// Features Section - Select Category.
$wp_customize->add_setting(
	'businesity_features_content_category',
	array(
		'sanitize_callback' => 'charityup_sanitize_select',
	)
);

$wp_customize->add_control(
	'businesity_features_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'businesity' ),
		'section'         => 'businesity_features_section',
		'settings'        => 'businesity_features_content_category',
		'active_callback' => 'businesity_is_features_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => charityup_get_post_cat_choices(),
	)
);

// Features Section - Button Label.
$wp_customize->add_setting(
	'businesity_features_button_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'businesity_features_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'businesity' ),
		'section'         => 'businesity_features_section',
		'settings'        => 'businesity_features_button_label',
		'type'            => 'text',
		'active_callback' => 'businesity_is_features_section_enabled',
	)
);

// Features Section - Button Link.
$wp_customize->add_setting(
	'businesity_features_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'businesity_features_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'businesity' ),
		'section'         => 'businesity_features_section',
		'settings'        => 'businesity_features_button_link',
		'type'            => 'url',
		'active_callback' => 'businesity_is_features_section_enabled',
	)
);
